/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.BrokerPool;

public class ConfigurationHelper {
    private static final Logger LOG = LogManager.getLogger(ConfigurationHelper.class);

    public static Optional<Path> getExistHome() {
        return ConfigurationHelper.getExistHome("conf.xml");
    }

    public static Optional<Path> getExistHome(String config) {
        Path existHome;
        try {
            Optional<Path> existHome2;
            BrokerPool broker = BrokerPool.getInstance();
            if (broker != null && (existHome2 = broker.getConfiguration().getExistHome()).isPresent()) {
                LOG.debug("Got eXist home from broker: " + existHome2);
                return existHome2;
            }
        }
        catch (Throwable e) {
            LOG.debug("Could not retrieve instance of BrokerPool: {}", (Object)e.getMessage());
        }
        if (System.getProperty("exist.home") != null && Files.isDirectory(existHome = ConfigurationHelper.decodeUserHome(System.getProperty("exist.home")), new LinkOption[0])) {
            LOG.debug("Got eXist home from system property 'exist.home': {}", (Object)existHome.toAbsolutePath().toString());
            return Optional.of(existHome);
        }
        Path userHome = Paths.get(System.getProperty("user.home"), new String[0]);
        Path userHomeRelativeConfig = userHome.resolve(config);
        if (Files.isDirectory(userHome, new LinkOption[0]) && Files.isRegularFile(userHomeRelativeConfig, new LinkOption[0])) {
            Path existHome3 = userHomeRelativeConfig.getParent();
            LOG.debug("Got eXist home: {} from system property 'user.home': {}", (Object)existHome3.toAbsolutePath().toString(), (Object)userHome.toAbsolutePath().toString());
            return Optional.of(existHome3);
        }
        Path userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        Path userDirRelativeConfig = userDir.resolve(config);
        if (Files.isDirectory(userDir, new LinkOption[0]) && Files.isRegularFile(userDirRelativeConfig, new LinkOption[0])) {
            Path existHome4 = userDirRelativeConfig.getParent();
            LOG.debug("Got eXist home: {} from system property 'user.dir': {}", (Object)existHome4.toAbsolutePath().toString(), (Object)userDir.toAbsolutePath().toString());
            return Optional.of(existHome4);
        }
        URL configUrl = ConfigurationHelper.class.getClassLoader().getResource(config);
        if (configUrl != null) {
            try {
                Path existHome5 = Paths.get(configUrl.toURI()).getParent();
                LOG.debug("Got eXist home from classpath: {}", (Object)existHome5.toAbsolutePath().toString());
                return Optional.of(existHome5);
            }
            catch (URISyntaxException e) {
                LOG.error("Could not derive EXIST_HOME from classpath:: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return Optional.empty();
    }

    public static Path lookup(String path) {
        return ConfigurationHelper.lookup(path, Optional.empty());
    }

    public static Path lookup(String path, Optional<Path> parent) {
        Path p = ConfigurationHelper.decodeUserHome(path);
        if (p.isAbsolute()) {
            return p;
        }
        return parent.orElse(ConfigurationHelper.getExistHome().orElse(Paths.get(System.getProperty("user.dir"), new String[0]))).resolve(path);
    }

    public static Path decodeUserHome(String path) {
        if (path != null && path.startsWith("~") && path.length() > 1) {
            return Paths.get(System.getProperty("user.home"), new String[0]).resolve(path.substring(1));
        }
        return Paths.get(path, new String[0]);
    }
}

