/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.lang.reflect.Method;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExistSAXParserFactory {
    private static final Logger LOG = LogManager.getLogger(ExistSAXParserFactory.class);
    public static final String ORG_EXIST_SAXPARSERFACTORY = "org.exist.SAXParserFactory";

    public static SAXParserFactory getSAXParserFactory(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception ex) {
            LOG.debug(className + ": " + ex.getMessage(), (Throwable)ex);
            return null;
        }
        Method method = null;
        try {
            method = clazz.getMethod("newInstance", null);
        }
        catch (Exception ex) {
            LOG.debug("Method " + className + ".newInstance not found.", (Throwable)ex);
            return null;
        }
        Object result = null;
        try {
            result = method.invoke(null, (Object[])null);
        }
        catch (Exception ex) {
            LOG.debug("Could not invoke method " + className + ".newInstance.", (Throwable)ex);
            return null;
        }
        if (!(result instanceof SAXParserFactory)) {
            LOG.debug("Could not create instance of SAXParserFactory: " + result.toString());
            return null;
        }
        return (SAXParserFactory)result;
    }

    public static SAXParserFactory getSAXParserFactory() {
        SAXParserFactory factory = null;
        String config = System.getProperty(ORG_EXIST_SAXPARSERFACTORY);
        if (config != null) {
            factory = ExistSAXParserFactory.getSAXParserFactory(config);
        }
        if (factory == null) {
            factory = SAXParserFactory.newInstance();
            LOG.debug(String.format("Using default SAXParserFactory '%s'", factory.getClass().getCanonicalName()));
        }
        return factory;
    }
}

