/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.EXistInputSource;

public class FileInputSource
extends EXistInputSource {
    private static final Logger LOG = LogManager.getLogger(FileInputSource.class);
    private Optional<Path> file = Optional.empty();
    private Optional<InputStream> inputStream = Optional.empty();

    public FileInputSource(Path file) {
        this.setFile(file);
    }

    public Path getFile() {
        return this.file.orElse(null);
    }

    public void setFile(Path file) {
        this.assertOpen();
        this.close();
        this.file = Optional.of(file);
        this.reOpen();
        super.setSystemId(this.file.map(f -> f.toUri().toASCIIString()).orElse(null));
    }

    @Override
    public InputStream getByteStream() {
        this.assertOpen();
        this.close();
        if (this.file.isPresent()) {
            try {
                this.inputStream = Optional.of(new BufferedInputStream(Files.newInputStream(this.file.get(), new OpenOption[0])));
                this.reOpen();
                return this.inputStream.get();
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
        return null;
    }

    @Override
    public void setByteStream(InputStream is) {
        this.assertOpen();
    }

    @Override
    public void setCharacterStream(Reader r) {
        this.assertOpen();
    }

    @Override
    public void setSystemId(String systemId) {
        this.assertOpen();
    }

    @Override
    public long getByteStreamLength() {
        this.assertOpen();
        if (this.file.isPresent()) {
            try {
                return Files.size(this.file.get());
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
        return -1L;
    }

    @Override
    public String getSymbolicPath() {
        this.assertOpen();
        return this.file.map(Path::toAbsolutePath).map(Path::toString).orElse(null);
    }

    @Override
    public void close() {
        block6: {
            if (!this.isClosed()) {
                try {
                    if (!this.inputStream.isPresent()) break block6;
                    try {
                        this.inputStream.get().close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)e);
                    }
                    this.inputStream = Optional.empty();
                }
                finally {
                    super.close();
                }
            }
        }
    }
}

