/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import com.evolvedbinary.j8fu.Either;
import com.evolvedbinary.j8fu.function.FunctionE;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    private static final Logger LOG = LogManager.getLogger(FileUtils.class);
    private static final SimpleFileVisitor<Path> deleteDirVisitor = new DeleteDirVisitor();

    public static Path[] asPaths(File[] files) {
        return FileUtils.asPathsList(files).toArray(new Path[files.length]);
    }

    public static List<Path> asPathsList(File[] files) {
        return Optional.ofNullable(files).map(fs -> Arrays.stream(fs).map(File::toPath).collect(Collectors.toList())).orElse(Collections.EMPTY_LIST);
    }

    public static void delete(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Files.deleteIfExists(path);
        } else {
            Files.walkFileTree(path, deleteDirVisitor);
        }
    }

    public static boolean deleteQuietly(Path path) {
        try {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return Files.deleteIfExists(path);
            }
            Files.walkFileTree(path, deleteDirVisitor);
            return true;
        }
        catch (IOException ioe) {
            LOG.error("Unable to delete: " + path.toAbsolutePath().toString(), (Throwable)ioe);
            return false;
        }
    }

    public static long sizeQuietly(Collection<Path> paths) {
        return paths.stream().map(FileUtils::sizeQuietly).filter(size -> size != -1L).reduce((a, b) -> a + b).orElse(-1L);
    }

    public static long sizeQuietly(Path path) {
        try {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return Files.size(path);
            }
            DirSizeVisitor dirSizeVisitor = new DirSizeVisitor();
            Files.walkFileTree(path, dirSizeVisitor);
            return dirSizeVisitor.totalSize();
        }
        catch (IOException ioe) {
            LOG.error("Unable to determine size of: " + path.toString(), (Throwable)ioe);
            return -1L;
        }
    }

    public static long measureFileStore(Path path, FunctionE<FileStore, Long, IOException> measurer) {
        try {
            return (Long)measurer.apply((Object)Files.getFileStore(path));
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
            return -1L;
        }
    }

    public static Either<IOException, FileTime> lastModifiedQuietly(Path path) {
        try {
            return Either.Right((Object)Files.getLastModifiedTime(path, new LinkOption[0]));
        }
        catch (IOException e) {
            return Either.Left((Object)e);
        }
    }

    public static boolean mkdirsQuietly(Path dir) {
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            return true;
        }
        catch (IOException ioe) {
            LOG.error("Unable to mkdirs: " + dir.toAbsolutePath().toString(), (Throwable)ioe);
            return false;
        }
    }

    public static Path resolve(Optional<Path> parent, String child) {
        return parent.map(p -> p.resolve(child)).orElse(Paths.get(child, new String[0]));
    }

    public static String fileName(Path path) {
        return path.getFileName().toString();
    }

    public static List<Path> list(Path directory) throws IOException {
        try (Stream<Path> entries = Files.list(directory);){
            List<Path> list = entries.collect(Collectors.toList());
            return list;
        }
    }

    public static List<Path> list(Path directory, Predicate<Path> filter) throws IOException {
        try (Stream<Path> entries = Files.list(directory).filter(filter);){
            List<Path> list = entries.collect(Collectors.toList());
            return list;
        }
    }

    public static String dirname(String path) {
        int islash = path.lastIndexOf(47);
        if (islash >= 0 && islash < path.length() - 1) {
            return path.substring(0, islash);
        }
        if (islash >= 0) {
            return path;
        }
        return ".";
    }

    public static String addPaths(String path1, String path2) {
        if (path1.endsWith("/") || path2.endsWith(File.separator)) {
            if (path2.startsWith("/") || path2.startsWith(File.separator)) {
                return path1 + path2.substring(1);
            }
            return path1 + path2;
        }
        if (path2.startsWith("/") || path2.startsWith(File.separator)) {
            return path1 + path2;
        }
        return path1 + File.separatorChar + path2;
    }

    private static class DirSizeVisitor
    extends SimpleFileVisitor<Path> {
        private long size = 0L;

        private DirSizeVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.size += Files.size(file);
            return FileVisitResult.CONTINUE;
        }

        public long totalSize() {
            return this.size;
        }
    }

    private static class DeleteDirVisitor
    extends SimpleFileVisitor<Path> {
        private DeleteDirVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc != null) {
                throw exc;
            }
            Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

