/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.EXistInputSource;

public final class GZIPInputSource
extends EXistInputSource {
    private static final Logger LOG = LogManager.getLogger(GZIPInputSource.class);
    private final Path gzipFile;
    private Optional<InputStream> inputStream = Optional.empty();

    public GZIPInputSource(Path gzipFile) {
        this.gzipFile = gzipFile;
    }

    @Override
    public InputStream getByteStream() {
        this.assertOpen();
        try {
            BufferedInputStream is = new BufferedInputStream(Files.newInputStream(this.gzipFile, new OpenOption[0]));
            this.inputStream = Optional.of(new GZIPInputStream(is));
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
        }
        return this.inputStream.orElse(null);
    }

    @Override
    public void setByteStream(InputStream is) {
        this.assertOpen();
    }

    @Override
    public void setCharacterStream(Reader r) {
        this.assertOpen();
    }

    @Override
    public void setSystemId(String systemId) {
        this.assertOpen();
    }

    @Override
    public long getByteStreamLength() {
        this.assertOpen();
        try {
            return Files.size(this.gzipFile);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return -1L;
        }
    }

    @Override
    public String getSymbolicPath() {
        this.assertOpen();
        return this.gzipFile.toAbsolutePath().toString();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        block9: {
            if (!this.isClosed()) {
                try {
                    if (!this.inputStream.isPresent()) break block9;
                    try {
                        this.inputStream.get().close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)e);
                    }
                    finally {
                        this.inputStream = Optional.empty();
                    }
                }
                finally {
                    super.close();
                }
            }
        }
    }
}

