/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.exist.dom.persistent.NodeProxy;
import org.exist.numbering.NodeId;

public final class HSort {
    public static <C extends Comparable<? super C>> void sort(C[] a, int lo, int hi) {
        int first;
        if (lo >= hi) {
            return;
        }
        int drop = 1;
        for (int k = first = (hi + lo - 1) / 2; k >= lo; --k) {
            if (k == (first - 1) / 2) {
                ++drop;
                first = k;
            }
            HSort.siftdown(a, (int)(hi + 1), (int)k, a[k], (int)drop);
        }
        int last = Integer.highestOneBit(hi - lo);
        drop = 31 - Integer.numberOfLeadingZeros(last);
        int lastlo = last + lo;
        for (int k = hi; k > lo; --k) {
            C temp = a[k];
            a[k] = a[lo];
            HSort.siftdown(a, (int)k, (int)lo, temp, (int)drop);
            if (k != lastlo) continue;
            --drop;
            lastlo = (last /= 2) + lo;
        }
    }

    public static <C extends Comparable<? super C>> void sort(C[] a, int lo, int hi, int[] b) {
        int first;
        if (lo >= hi) {
            return;
        }
        int drop = 1;
        for (int k = first = (hi + lo - 1) / 2; k >= lo; --k) {
            if (k == (first - 1) / 2) {
                ++drop;
                first = k;
            }
            HSort.siftdown(a, (int[])b, (int)(hi + 1), (int)k, a[k], (int)(b != null ? b[k] : 0), (int)drop);
        }
        int last = Integer.highestOneBit(hi - lo);
        drop = 31 - Integer.numberOfLeadingZeros(last);
        int lastlo = last + lo;
        for (int k = hi; k > lo; --k) {
            int tempB;
            C temp = a[k];
            a[k] = a[lo];
            if (b != null) {
                tempB = b[k];
                b[k] = b[lo];
            } else {
                tempB = 0;
            }
            HSort.siftdown(a, (int[])b, (int)k, (int)lo, temp, (int)tempB, (int)drop);
            if (k != lastlo) continue;
            --drop;
            lastlo = (last /= 2) + lo;
        }
    }

    public static <C> void sort(C[] a, Comparator<C> c, int lo, int hi) {
        int first;
        if (lo >= hi) {
            return;
        }
        int drop = 1;
        for (int k = first = (hi + lo - 1) / 2; k >= lo; --k) {
            if (k == (first - 1) / 2) {
                ++drop;
                first = k;
            }
            HSort.siftdown(a, c, hi + 1, k, a[k], drop);
        }
        int last = Integer.highestOneBit(hi - lo);
        drop = 31 - Integer.numberOfLeadingZeros(last);
        int lastlo = last + lo;
        for (int k = hi; k > lo; --k) {
            C temp = a[k];
            a[k] = a[lo];
            HSort.siftdown(a, c, k, lo, temp, drop);
            if (k != lastlo) continue;
            --drop;
            lastlo = (last /= 2) + lo;
        }
    }

    public static <C extends Comparable<? super C>> void sort(List<C> a, int lo, int hi) {
        int first;
        if (lo >= hi) {
            return;
        }
        int drop = 1;
        for (int k = first = (hi + lo - 1) / 2; k >= lo; --k) {
            if (k == (first - 1) / 2) {
                ++drop;
                first = k;
            }
            HSort.siftdown(a, hi + 1, k, (Comparable)a.get(k), drop);
        }
        int last = Integer.highestOneBit(hi - lo);
        drop = 31 - Integer.numberOfLeadingZeros(last);
        int lastlo = last + lo;
        for (int k = hi; k > lo; --k) {
            Comparable temp = (Comparable)a.get(k);
            a.set(k, a.get(lo));
            HSort.siftdown(a, k, lo, temp, drop);
            if (k != lastlo) continue;
            --drop;
            lastlo = (last /= 2) + lo;
        }
    }

    public static void sort(long[] a, int lo, int hi, Object[] b) {
        int first;
        if (lo >= hi) {
            return;
        }
        int drop = 1;
        for (int k = first = (hi + lo - 1) / 2; k >= lo; --k) {
            if (k == (first - 1) / 2) {
                ++drop;
                first = k;
            }
            HSort.siftdown(a, b, hi + 1, k, a[k], b != null ? b[k] : null, drop);
        }
        int last = Integer.highestOneBit(hi - lo);
        drop = 31 - Integer.numberOfLeadingZeros(last);
        int lastlo = last + lo;
        for (int k = hi; k > lo; --k) {
            Object tempB;
            long temp = a[k];
            a[k] = a[lo];
            if (b != null) {
                tempB = b[k];
                b[k] = b[lo];
            } else {
                tempB = null;
            }
            HSort.siftdown(a, b, k, lo, temp, tempB, drop);
            if (k != lastlo) continue;
            --drop;
            lastlo = (last /= 2) + lo;
        }
    }

    public static void sortByNodeId(NodeProxy[] a, int lo, int hi) {
        int first;
        if (lo >= hi) {
            return;
        }
        int drop = 1;
        for (int k = first = (hi + lo - 1) / 2; k >= lo; --k) {
            if (k == (first - 1) / 2) {
                ++drop;
                first = k;
            }
            HSort.siftdownByNodeId(a, hi + 1, k, a[k], drop);
        }
        int last = Integer.highestOneBit(hi - lo);
        drop = 31 - Integer.numberOfLeadingZeros(last);
        int lastlo = last + lo;
        for (int k = hi; k > lo; --k) {
            NodeProxy temp = a[k];
            a[k] = a[lo];
            HSort.siftdownByNodeId(a, k, lo, temp, drop);
            if (k != lastlo) continue;
            --drop;
            lastlo = (last /= 2) + lo;
        }
    }

    private static <C extends Comparable<? super C>> void siftdown(C[] a, int n, int vacant, C missing, int drop) {
        int memo = vacant;
        int count = 0;
        int next_peek = (drop + 1) / 2;
        int child = 2 * (vacant + 1);
        while (child < n) {
            if (a[child].compareTo(a[child - 1]) < 0) {
                --child;
            }
            a[vacant] = a[child];
            vacant = child;
            child = 2 * (vacant + 1);
            if (++count != next_peek) continue;
            if (a[(vacant - 1) / 2].compareTo(missing) <= 0) break;
            next_peek = (count + drop + 1) / 2;
        }
        if (child == n) {
            a[vacant] = a[n - 1];
            vacant = n - 1;
        }
        int parent = (vacant - 1) / 2;
        while (vacant > memo && a[parent].compareTo(missing) < 0) {
            a[vacant] = a[parent];
            vacant = parent;
            parent = (vacant - 1) / 2;
        }
        a[vacant] = missing;
    }

    private static <C extends Comparable<? super C>> void siftdown(C[] a, int[] b, int n, int vacant, C missing, int missingB, int drop) {
        int memo = vacant;
        int count = 0;
        int next_peek = (drop + 1) / 2;
        int child = 2 * (vacant + 1);
        while (child < n) {
            if (a[child].compareTo(a[child - 1]) < 0) {
                --child;
            }
            a[vacant] = a[child];
            if (b != null) {
                b[vacant] = b[child];
            }
            vacant = child;
            child = 2 * (vacant + 1);
            if (++count != next_peek) continue;
            if (a[(vacant - 1) / 2].compareTo(missing) <= 0) break;
            next_peek = (count + drop + 1) / 2;
        }
        if (child == n) {
            a[vacant] = a[n - 1];
            if (b != null) {
                b[vacant] = b[n - 1];
            }
            vacant = n - 1;
        }
        int parent = (vacant - 1) / 2;
        while (vacant > memo && a[parent].compareTo(missing) < 0) {
            a[vacant] = a[parent];
            if (b != null) {
                b[vacant] = b[parent];
            }
            vacant = parent;
            parent = (vacant - 1) / 2;
        }
        a[vacant] = missing;
        if (b != null) {
            b[vacant] = missingB;
        }
    }

    private static <C> void siftdown(C[] a, Comparator<C> c, int n, int vacant, C missing, int drop) {
        int memo = vacant;
        int count = 0;
        int next_peek = (drop + 1) / 2;
        int child = 2 * (vacant + 1);
        while (child < n) {
            if (c.compare(a[child], a[child - 1]) < 0) {
                --child;
            }
            a[vacant] = a[child];
            vacant = child;
            child = 2 * (vacant + 1);
            if (++count != next_peek) continue;
            if (c.compare(a[(vacant - 1) / 2], missing) <= 0) break;
            next_peek = (count + drop + 1) / 2;
        }
        if (child == n) {
            a[vacant] = a[n - 1];
            vacant = n - 1;
        }
        int parent = (vacant - 1) / 2;
        while (vacant > memo && c.compare(a[parent], missing) < 0) {
            a[vacant] = a[parent];
            vacant = parent;
            parent = (vacant - 1) / 2;
        }
        a[vacant] = missing;
    }

    private static <C extends Comparable<? super C>> void siftdown(List<C> a, int n, int vacant, C missing, int drop) {
        int memo = vacant;
        int count = 0;
        int next_peek = (drop + 1) / 2;
        int child = 2 * (vacant + 1);
        while (child < n) {
            if (((Comparable)a.get(child)).compareTo(a.get(child - 1)) < 0) {
                --child;
            }
            a.set(vacant, a.get(child));
            vacant = child;
            child = 2 * (vacant + 1);
            if (++count != next_peek) continue;
            if (((Comparable)a.get((vacant - 1) / 2)).compareTo(missing) <= 0) break;
            next_peek = (count + drop + 1) / 2;
        }
        if (child == n) {
            a.set(vacant, a.get(n - 1));
            vacant = n - 1;
        }
        int parent = (vacant - 1) / 2;
        while (vacant > memo && ((Comparable)a.get(parent)).compareTo(missing) < 0) {
            a.set(vacant, a.get(parent));
            vacant = parent;
            parent = (vacant - 1) / 2;
        }
        a.set(vacant, missing);
    }

    private static void siftdown(long[] a, Object[] b, int n, int vacant, long missing, Object missingB, int drop) {
        int memo = vacant;
        int count = 0;
        int next_peek = (drop + 1) / 2;
        int child = 2 * (vacant + 1);
        while (child < n) {
            if (a[child] < a[child - 1]) {
                --child;
            }
            a[vacant] = a[child];
            if (b != null) {
                b[vacant] = b[child];
            }
            vacant = child;
            child = 2 * (vacant + 1);
            if (++count != next_peek) continue;
            if (a[(vacant - 1) / 2] <= missing) break;
            next_peek = (count + drop + 1) / 2;
        }
        if (child == n) {
            a[vacant] = a[n - 1];
            if (b != null) {
                b[vacant] = b[n - 1];
            }
            vacant = n - 1;
        }
        int parent = (vacant - 1) / 2;
        while (vacant > memo && a[parent] < missing) {
            a[vacant] = a[parent];
            if (b != null) {
                b[vacant] = b[parent];
            }
            vacant = parent;
            parent = (vacant - 1) / 2;
        }
        a[vacant] = missing;
        if (b != null) {
            b[vacant] = missingB;
        }
    }

    private static void siftdownByNodeId(NodeProxy[] a, int n, int vacant, NodeProxy missing, int drop) {
        int memo = vacant;
        int count = 0;
        int next_peek = (drop + 1) / 2;
        int child = 2 * (vacant + 1);
        NodeId missingNodeId = missing.getNodeId();
        while (child < n) {
            if (a[child].getNodeId().compareTo(a[child - 1].getNodeId()) < 0) {
                --child;
            }
            a[vacant] = a[child];
            vacant = child;
            child = 2 * (vacant + 1);
            if (++count != next_peek) continue;
            if (a[(vacant - 1) / 2].getNodeId().compareTo(missingNodeId) <= 0) break;
            next_peek = (count + drop + 1) / 2;
        }
        if (child == n) {
            a[vacant] = a[n - 1];
            vacant = n - 1;
        }
        int parent = (vacant - 1) / 2;
        while (vacant > memo && a[parent].getNodeId().compareTo(missingNodeId) < 0) {
            a[vacant] = a[parent];
            vacant = parent;
            parent = (vacant - 1) / 2;
        }
        a[vacant] = missing;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> l = new ArrayList<String>();
        if (args.length == 0) {
            String[] a = new String[]{"Rudi", "Herbert", "Anton", "Berta", "Olga", "Willi", "Heinz"};
            for (int i = 0; i < a.length; ++i) {
                l.add(a[i]);
            }
        } else {
            System.err.println("Ordering file " + args[0] + "\n");
            try (BufferedReader is = new BufferedReader(new FileReader(args[0]));){
                String rr;
                while ((rr = is.readLine()) != null) {
                    l.add(rr);
                }
            }
        }
        long a = System.currentTimeMillis();
        HSort.sort(l, 0, l.size() - 1);
        long b = System.currentTimeMillis();
        System.err.println("Ellapsed time: " + (b - a) + " size: " + l.size());
        for (int i = 0; i < l.size(); ++i) {
            System.out.println((String)l.get(i));
        }
    }
}

