/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.exist.dom.persistent.NodeProxy;
import org.exist.util.SwapVals;

public final class HeapSort {
    public static <C extends Comparable<? super C>> void sort(C[] a, int lo, int hi) {
        for (int i = hi - 1; i >= lo; --i) {
            HeapSort.fixHeap(a, (int)lo, (int)i, (int)hi);
        }
        while (lo < hi) {
            SwapVals.swap(a, lo, hi);
            HeapSort.fixHeap(a, (int)lo, (int)lo, (int)(--hi));
        }
    }

    public static <C extends Comparable<? super C>> void sort(C[] a, int lo, int hi, int[] b) {
        for (int i = hi - 1; i >= lo; --i) {
            HeapSort.fixHeap(a, (int[])b, (int)lo, (int)i, (int)hi);
        }
        while (lo < hi) {
            SwapVals.swap(a, lo, hi);
            if (b != null) {
                SwapVals.swap(b, lo, hi);
            }
            HeapSort.fixHeap(a, (int[])b, (int)lo, (int)lo, (int)(--hi));
        }
    }

    public static <C> void sort(C[] a, Comparator<C> c, int lo, int hi) {
        for (int i = hi - 1; i >= lo; --i) {
            HeapSort.fixHeap(a, c, lo, i, hi);
        }
        while (lo < hi) {
            SwapVals.swap(a, lo, hi);
            HeapSort.fixHeap(a, c, lo, lo, --hi);
        }
    }

    public static <C extends Comparable<? super C>> void sort(List<C> a, int lo, int hi) {
        for (int i = hi - 1; i >= lo; --i) {
            HeapSort.fixHeap(a, lo, i, hi);
        }
        while (lo < hi) {
            SwapVals.swap(a, lo, hi);
            HeapSort.fixHeap(a, lo, lo, --hi);
        }
    }

    public static void sort(long[] a, int lo, int hi, Object[] b) {
        for (int i = hi - 1; i >= lo; --i) {
            HeapSort.fixHeap(a, b, lo, i, hi);
        }
        while (lo < hi) {
            SwapVals.swap(a, lo, hi);
            if (b != null) {
                SwapVals.swap(b, lo, hi);
            }
            HeapSort.fixHeap(a, b, lo, lo, --hi);
        }
    }

    public static void sortByNodeId(NodeProxy[] a, int lo, int hi) {
        for (int i = hi - 1; i >= lo; --i) {
            HeapSort.fixHeapByNodeId(a, lo, i, hi);
        }
        while (lo < hi) {
            SwapVals.swap(a, lo, hi);
            HeapSort.fixHeapByNodeId(a, lo, lo, --hi);
        }
    }

    private static <C extends Comparable<? super C>> void fixHeap(C[] a, int root, int item, int end) {
        int child;
        while ((child = (item - root) * 2 + 1 + root) <= end && a[item].compareTo(a[child]) < 0 || child + 1 <= end && a[item].compareTo(a[child + 1]) < 0) {
            if (child + 1 > end || a[child].compareTo(a[child + 1]) >= 0) {
                SwapVals.swap(a, item, child);
                item = child;
                continue;
            }
            SwapVals.swap(a, item, child + 1);
            item = child + 1;
        }
        return;
    }

    private static <C extends Comparable<? super C>> void fixHeap(C[] a, int[] b, int root, int item, int end) {
        int child;
        while ((child = (item - root) * 2 + 1 + root) <= end && a[item].compareTo(a[child]) < 0 || child + 1 <= end && a[item].compareTo(a[child + 1]) < 0) {
            if (child + 1 > end || a[child].compareTo(a[child + 1]) >= 0) {
                SwapVals.swap(a, item, child);
                if (b != null) {
                    SwapVals.swap(b, item, child);
                }
                item = child;
                continue;
            }
            SwapVals.swap(a, item, child + 1);
            if (b != null) {
                SwapVals.swap(b, item, child + 1);
            }
            item = child + 1;
        }
        return;
    }

    private static <C> void fixHeap(C[] a, Comparator<C> c, int root, int item, int end) {
        int child;
        while ((child = (item - root) * 2 + 1 + root) <= end && c.compare(a[item], a[child]) < 0 || child + 1 <= end && c.compare(a[item], a[child + 1]) < 0) {
            if (child + 1 > end || c.compare(a[child], a[child + 1]) >= 0) {
                SwapVals.swap(a, item, child);
                item = child;
                continue;
            }
            SwapVals.swap(a, item, child + 1);
            item = child + 1;
        }
        return;
    }

    private static <C extends Comparable<? super C>> void fixHeap(List<C> a, int root, int item, int end) {
        int child;
        while ((child = (item - root) * 2 + 1 + root) <= end && ((Comparable)a.get(item)).compareTo(a.get(child)) < 0 || child + 1 <= end && ((Comparable)a.get(item)).compareTo(a.get(child + 1)) < 0) {
            if (child + 1 > end || ((Comparable)a.get(child)).compareTo(a.get(child + 1)) >= 0) {
                SwapVals.swap(a, item, child);
                item = child;
                continue;
            }
            SwapVals.swap(a, item, child + 1);
            item = child + 1;
        }
        return;
    }

    private static void fixHeap(long[] a, Object[] b, int root, int item, int end) {
        int child;
        while ((child = (item - root) * 2 + 1 + root) <= end && a[item] < a[child] || child + 1 <= end && a[item] < a[child + 1]) {
            if (child + 1 > end || a[child] >= a[child + 1]) {
                SwapVals.swap(a, item, child);
                if (b != null) {
                    SwapVals.swap(b, item, child);
                }
                item = child;
                continue;
            }
            SwapVals.swap(a, item, child + 1);
            if (b != null) {
                SwapVals.swap(b, item, child + 1);
            }
            item = child + 1;
        }
        return;
    }

    private static void fixHeapByNodeId(NodeProxy[] a, int root, int item, int end) {
        int child;
        while ((child = (item - root) * 2 + 1 + root) <= end && a[item].getNodeId().compareTo(a[child].getNodeId()) < 0 || child + 1 <= end && a[item].getNodeId().compareTo(a[child + 1].getNodeId()) < 0) {
            if (child + 1 > end || a[child].getNodeId().compareTo(a[child + 1].getNodeId()) >= 0) {
                SwapVals.swap(a, item, child);
                item = child;
                continue;
            }
            SwapVals.swap(a, item, child + 1);
            item = child + 1;
        }
        return;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> l = new ArrayList<String>();
        if (args.length == 0) {
            String[] a = new String[]{"Rudi", "Herbert", "Anton", "Berta", "Olga", "Willi", "Heinz"};
            for (int i = 0; i < a.length; ++i) {
                l.add(a[i]);
            }
        } else {
            System.err.println("Ordering file " + args[0] + "\n");
            try (BufferedReader is = new BufferedReader(new FileReader(args[0]));){
                String rr;
                while ((rr = is.readLine()) != null) {
                    l.add(rr);
                }
            }
        }
        long a = System.currentTimeMillis();
        HeapSort.sort(l, 0, l.size() - 1);
        long b = System.currentTimeMillis();
        System.err.println("Ellapsed time: " + (b - a) + " size: " + l.size());
        for (int i = 0; i < l.size(); ++i) {
            System.out.println((String)l.get(i));
        }
    }
}

