/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import com.evolvedbinary.j8fu.Either;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.Configuration;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class HtmlToXmlParser {
    private static final Logger LOG = LogManager.getLogger(HtmlToXmlParser.class);
    public static final String HTML_TO_XML_PARSER_ELEMENT = "html-to-xml";
    public static final String HTML_TO_XML_PARSER_CLASS_ATTRIBUTE = "class";
    public static final String HTML_TO_XML_PARSER_PROPERTIES_ELEMENT = "properties";
    public static final String HTML_TO_XML_PARSER_FEATURES_ELEMENT = "features";
    public static final String HTML_TO_XML_PARSER_PROPERTY = "parser.html-to-xml-parser";
    public static final String HTML_TO_XML_PARSER_PROPERTIES_PROPERTY = "parser.html-to-xml-parser.properties";
    public static final String HTML_TO_XML_PARSER_FEATURES_PROPERTY = "parser.html-to-xml-parser.features";
    public static final String PARSER_ELEMENT_NAME = "parser";

    public static Optional<Either<Throwable, XMLReader>> getHtmlToXmlParser(Configuration config) {
        Optional<String> parserClassName = Optional.ofNullable((String)config.getProperty(HTML_TO_XML_PARSER_PROPERTY));
        Optional<Either<Throwable, XMLReader>> inst = parserClassName.map(cn -> {
            Either result;
            try {
                Class<?> clazz = Class.forName(cn);
                if (XMLReader.class.isAssignableFrom(clazz)) {
                    Map properties;
                    XMLReader reader = (XMLReader)clazz.newInstance();
                    Map features = (Map)config.getProperty(HTML_TO_XML_PARSER_FEATURES_PROPERTY);
                    if (features != null) {
                        for (Map.Entry feature : features.entrySet()) {
                            reader.setFeature((String)feature.getKey(), (Boolean)feature.getValue());
                        }
                    }
                    if ((properties = (Map)config.getProperty(HTML_TO_XML_PARSER_PROPERTIES_PROPERTY)) != null) {
                        for (Map.Entry property : properties.entrySet()) {
                            reader.setProperty((String)property.getKey(), property.getValue());
                        }
                    }
                    result = Either.Right((Object)reader);
                } else {
                    result = Either.Left((Object)new ClassCastException(cn + " does not implement org.xml.sax.XMLReader"));
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SAXNotRecognizedException | SAXNotSupportedException e) {
                result = Either.Left((Object)e);
            }
            return result;
        });
        return inst;
    }
}

