/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.ConfigurationHelper;
import org.exist.util.FastStringBuffer;
import org.exist.util.FileUtils;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MimeTable {
    private static final Logger LOG = LogManager.getLogger(MimeTable.class);
    private static final String FILE_LOAD_FAILED_ERR = "Failed to load mime-type table from ";
    private static final String LOAD_FAILED_ERR = "Failed to load mime-type table from class loader";
    private static final String MIME_TYPES_XML = "mime-types.xml";
    private static final String MIME_TYPES_XML_DEFAULT = "org/exist/util/mime-types.xml";
    private static MimeTable instance = null;
    private String src;
    private MimeType defaultMime = null;
    private Map<String, MimeType> mimeTypes = new TreeMap<String, MimeType>();
    private Map<String, MimeType> extensions = new TreeMap<String, MimeType>();
    private Map<String, String> preferredExtension = new TreeMap<String, String>();

    public static MimeTable getInstance() {
        if (instance == null) {
            instance = new MimeTable();
        }
        return instance;
    }

    public static MimeTable getInstance(Path path) {
        if (instance == null) {
            instance = new MimeTable(path);
        }
        return instance;
    }

    public static MimeTable getInstance(InputStream stream, String src) {
        if (instance == null) {
            instance = new MimeTable(stream, src);
        }
        return instance;
    }

    public MimeTable() {
        this.load();
    }

    public MimeTable(Path path) {
        this.load(path);
    }

    public MimeTable(InputStream stream, String src) {
        this.load(stream, src);
    }

    public String getSrc() {
        return this.src;
    }

    public MimeType getContentTypeFor(String fileName) {
        String ext = this.getExtension(fileName);
        MimeType mt = ext == null ? this.defaultMime : this.extensions.get(ext);
        return mt == null ? this.defaultMime : mt;
    }

    public MimeType getContentTypeFor(XmldbURI fileName) {
        return this.getContentTypeFor(fileName.toString());
    }

    public MimeType getContentType(String mimeType) {
        return this.mimeTypes.get(mimeType);
    }

    public List<String> getAllExtensions(MimeType mimeType) {
        return this.getAllExtensions(mimeType.getName());
    }

    public List<String> getAllExtensions(String mimeType) {
        ArrayList<String> extns = new ArrayList<String>();
        for (Map.Entry<String, MimeType> extension : this.extensions.entrySet()) {
            MimeType mt = extension.getValue();
            if (!mt.getName().equals(mimeType)) continue;
            extns.add(extension.getKey());
        }
        String preferred = this.preferredExtension.get(mimeType);
        if (preferred != null && !extns.contains(preferred)) {
            extns.add(0, preferred);
        }
        return extns;
    }

    public String getPreferredExtension(MimeType mimeType) {
        return this.getPreferredExtension(mimeType.getName());
    }

    public String getPreferredExtension(String mimeType) {
        return this.preferredExtension.get(mimeType);
    }

    public boolean isXMLContent(String fileName) {
        String ext = this.getExtension(fileName);
        if (ext == null) {
            return false;
        }
        MimeType type = this.extensions.get(ext);
        if (type == null) {
            return false;
        }
        return type.getType() == 0;
    }

    public boolean isTextContent(String mimeType) {
        MimeType mime = this.getContentType(mimeType);
        return mimeType.startsWith("text/") || mimeType.endsWith("xquery") || mime.isXMLType();
    }

    private String getExtension(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        int p = (fileName = FileUtils.fileName(path)).lastIndexOf(46);
        if (p < 0 || p + 1 == fileName.length()) {
            return null;
        }
        return fileName.substring(p).toLowerCase();
    }

    private void load() {
        this.load(ConfigurationHelper.lookup(MIME_TYPES_XML));
    }

    private void load(InputStream stream, String src) {
        boolean loaded = false;
        System.out.println("Loading mime table from stream " + src);
        try {
            this.loadMimeTypes(stream);
            this.src = src;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error(LOAD_FAILED_ERR, (Throwable)e);
        }
        if (!loaded) {
            ClassLoader cl = MimeTable.class.getClassLoader();
            InputStream is = cl.getResourceAsStream(MIME_TYPES_XML_DEFAULT);
            if (is == null) {
                LOG.error(LOAD_FAILED_ERR);
            }
            try {
                this.loadMimeTypes(is);
                this.src = "resource://org/exist/util/mime-types.xml";
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LOG.error(LOAD_FAILED_ERR, (Throwable)e);
            }
        }
    }

    private void load(Path path) {
        boolean loaded = false;
        if (Files.isReadable(path)) {
            try {
                LOG.info("Loading mime table from file " + path.toAbsolutePath().toString());
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    this.loadMimeTypes(is);
                }
                loaded = true;
                this.src = path.toUri().toString();
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LOG.error(FILE_LOAD_FAILED_ERR + path.toAbsolutePath().toString(), (Throwable)e);
            }
        }
        if (!loaded) {
            ClassLoader cl = MimeTable.class.getClassLoader();
            InputStream is = cl.getResourceAsStream(MIME_TYPES_XML_DEFAULT);
            if (is == null) {
                LOG.error(LOAD_FAILED_ERR);
            }
            try {
                this.loadMimeTypes(is);
                this.src = "resource://org/exist/util/mime-types.xml";
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LOG.error(LOAD_FAILED_ERR, (Throwable)e);
            }
        }
    }

    private void loadMimeTypes(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        InputSource src = new InputSource(stream);
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setContentHandler(new MimeTableHandler());
        reader.parse(src);
    }

    public static void main(String[] args) {
        MimeTable table = MimeTable.getInstance();
        MimeType type = table.getContentTypeFor("samples/xquery/fibo.svg");
        if (type == null) {
            System.out.println("Not found!");
        } else {
            System.out.println(type.getName());
            System.out.println(type.getDescription());
        }
    }

    private class MimeTableHandler
    extends DefaultHandler {
        private static final String EXTENSIONS = "extensions";
        private static final String DESCRIPTION = "description";
        private static final String MIME_TYPE = "mime-type";
        private static final String MIME_TYPES = "mime-types";
        private MimeType mime = null;
        private FastStringBuffer charBuf = new FastStringBuffer(64);

        private MimeTableHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (MIME_TYPES.equals(qName)) {
                String defaultMimeAttr = attributes.getValue("default-mime-type");
                String defaultTypeAttr = attributes.getValue("default-resource-type");
                int type = 0;
                if (defaultTypeAttr != null && "binary".equals(defaultTypeAttr)) {
                    type = 1;
                }
                if (defaultMimeAttr != null && defaultMimeAttr.length() > 0) {
                    MimeTable.this.defaultMime = new MimeType(defaultMimeAttr, type);
                } else if (defaultTypeAttr != null) {
                    if (type == 0) {
                        MimeTable.this.defaultMime = MimeType.XML_TYPE;
                    } else if (type == 1) {
                        MimeTable.this.defaultMime = MimeType.BINARY_TYPE;
                    }
                }
                if (MimeTable.this.defaultMime != null) {
                    MimeTable.this.mimeTypes.put(MimeTable.this.defaultMime.getName(), MimeTable.this.defaultMime);
                }
            }
            if (MIME_TYPE.equals(qName)) {
                String name = attributes.getValue("name");
                if (name == null || name.length() == 0) {
                    LOG.error("No name specified for mime-type");
                    return;
                }
                int type = 1;
                String typeAttr = attributes.getValue("type");
                if (typeAttr != null && "xml".equals(typeAttr)) {
                    type = 0;
                }
                this.mime = new MimeType(name, type);
                MimeTable.this.mimeTypes.put(name, this.mime);
            }
            this.charBuf.setLength(0);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (MIME_TYPE.equals(qName)) {
                this.mime = null;
            } else if (DESCRIPTION.equals(qName)) {
                if (this.mime != null) {
                    String description = this.charBuf.getNormalizedString(3);
                    this.mime.setDescription(description);
                }
            } else if (EXTENSIONS.equals(qName) && this.mime != null) {
                String extList = this.charBuf.getNormalizedString(3);
                StringTokenizer tok = new StringTokenizer(extList, ", ");
                String preferred = null;
                while (tok.hasMoreTokens()) {
                    String ext = tok.nextToken().toLowerCase();
                    if (!MimeTable.this.extensions.containsKey(ext)) {
                        MimeTable.this.extensions.put(ext, this.mime);
                    }
                    if (preferred != null) continue;
                    preferred = ext;
                }
                MimeTable.this.preferredExtension.put(this.mime.getName(), preferred);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.charBuf.append(ch, start, length);
        }
    }
}

