/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.regex.Pattern;

public class PatternFactory {
    private static final PatternFactory instance = new PatternFactory();
    private final Cache<String, Pattern> cache = Caffeine.newBuilder().maximumSize(1000L).build();

    private PatternFactory() {
    }

    public static PatternFactory getInstance() {
        return instance;
    }

    public Pattern getPattern(String pattern) {
        return (Pattern)this.cache.get((Object)pattern, ptn -> Pattern.compile(ptn));
    }

    public Pattern getPattern(String pattern, int flags) {
        return (Pattern)this.cache.get((Object)(pattern + flags), key -> Pattern.compile(pattern, flags));
    }
}

