/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class VirtualTempFile
extends OutputStream {
    private static final Logger LOG = LogManager.getLogger(VirtualTempFile.class);
    private static final int DEFAULT_MAX_CHUNK_SIZE = 262144;
    private static final String DEFAULT_TEMP_PREFIX = "eXistRPCV";
    private static final String DEFAULT_TEMP_POSTFIX = ".res";
    protected File tempFile;
    protected boolean deleteTempFile;
    protected ByteArrayOutputStream baBuffer;
    protected FileOutputStream strBuffer;
    protected OutputStream os;
    protected byte[] tempBuffer;
    protected int maxMemorySize;
    protected int maxChunkSize;
    protected long vLength;
    protected String temp_prefix;
    protected String temp_postfix;

    public VirtualTempFile() {
        this(262144, 262144);
    }

    public VirtualTempFile(int maxMemorySize, int maxChunkSize) {
        this.maxMemorySize = maxMemorySize;
        this.maxChunkSize = maxChunkSize;
        this.vLength = -1L;
        this.baBuffer = new ByteArrayOutputStream(maxMemorySize);
        this.strBuffer = null;
        this.tempFile = null;
        this.tempBuffer = null;
        this.deleteTempFile = true;
        this.os = this.baBuffer;
        this.temp_prefix = DEFAULT_TEMP_PREFIX;
        this.temp_postfix = DEFAULT_TEMP_POSTFIX;
    }

    public VirtualTempFile(File theFile) {
        this(theFile, 262144);
    }

    public VirtualTempFile(File theFile, int maxChunkSize) {
        this.maxMemorySize = maxChunkSize;
        this.maxChunkSize = maxChunkSize;
        this.baBuffer = null;
        this.strBuffer = null;
        this.os = null;
        this.tempFile = theFile;
        this.deleteTempFile = false;
        this.vLength = theFile.length();
        this.tempBuffer = null;
        this.temp_prefix = DEFAULT_TEMP_PREFIX;
        this.temp_postfix = DEFAULT_TEMP_POSTFIX;
    }

    public VirtualTempFile(byte[] theBlock) {
        this(theBlock, theBlock.length, 262144);
    }

    public VirtualTempFile(byte[] theBlock, int maxMemorySize, int maxChunkSize) {
        this.maxMemorySize = maxMemorySize;
        this.maxChunkSize = maxChunkSize;
        this.baBuffer = null;
        this.strBuffer = null;
        this.os = null;
        this.temp_prefix = DEFAULT_TEMP_PREFIX;
        this.temp_postfix = DEFAULT_TEMP_POSTFIX;
        this.tempFile = null;
        this.deleteTempFile = true;
        this.vLength = theBlock.length;
        if (this.vLength <= (long)maxMemorySize) {
            this.tempBuffer = theBlock;
        } else {
            try {
                this.tempFile = File.createTempFile(this.temp_prefix, this.temp_postfix);
                this.tempFile.deleteOnExit();
                LOG.debug("Writing to temporary file: " + this.tempFile.getName());
                try (FileOutputStream tmpBuffer = new FileOutputStream(this.tempFile);){
                    ((OutputStream)tmpBuffer).write(theBlock);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getTempPrefix() {
        return this.temp_prefix;
    }

    public String getTempPostfix() {
        return this.temp_postfix;
    }

    public void setTempPrefix(String newPrefix) {
        if (newPrefix == null) {
            newPrefix = DEFAULT_TEMP_PREFIX;
        }
        this.temp_prefix = newPrefix;
    }

    public void setTempPostfix(String newPostfix) {
        if (newPostfix == null) {
            newPostfix = DEFAULT_TEMP_POSTFIX;
        }
        this.temp_postfix = newPostfix;
    }

    @Override
    public void close() throws IOException {
        if (this.baBuffer != null) {
            this.tempBuffer = this.baBuffer.toByteArray();
            this.baBuffer = null;
            this.vLength = this.tempBuffer.length;
        }
        if (this.strBuffer != null) {
            this.strBuffer.close();
            this.strBuffer = null;
            this.vLength = this.tempFile.length();
        }
        if (this.os != null) {
            this.os = null;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.os == null) {
            throw new IOException("No stream to flush");
        }
        this.os.flush();
    }

    public byte[] getChunk(long offset) throws IOException {
        byte[] data = null;
        if (this.os != null) {
            this.close();
        }
        if (this.tempFile != null) {
            RandomAccessFile raf = new RandomAccessFile(this.tempFile, "r");
            raf.seek(offset);
            long remaining = raf.length() - offset;
            if (remaining > (long)this.maxChunkSize) {
                remaining = this.maxChunkSize;
            } else if (remaining < 0L) {
                remaining = 0L;
            }
            data = new byte[(int)remaining];
            raf.readFully(data);
            raf.close();
        } else if (this.tempBuffer != null) {
            long remaining = (long)this.tempBuffer.length - offset;
            if (remaining > (long)this.maxChunkSize) {
                remaining = this.maxChunkSize;
            } else if (remaining < 0L) {
                remaining = 0L;
            }
            data = new byte[(int)remaining];
            if (remaining > 0L) {
                System.arraycopy(this.tempBuffer, (int)offset, data, 0, (int)remaining);
            }
        }
        return data;
    }

    public boolean exists() {
        return this.tempFile != null || this.tempBuffer != null || this.baBuffer != null;
    }

    public long length() {
        if (this.os != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.vLength;
    }

    public boolean delete() {
        if (this.os != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.tempFile != null) {
            if (this.strBuffer != null) {
                try {
                    this.strBuffer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.strBuffer = null;
            }
            if (this.deleteTempFile) {
                this.tempFile.delete();
            }
            this.tempFile = null;
        }
        if (this.baBuffer != null) {
            try {
                this.baBuffer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.baBuffer = null;
        }
        if (this.tempBuffer != null) {
            this.tempBuffer = null;
        }
        return true;
    }

    private void writeSwitch() throws IOException {
        if (this.tempFile == null) {
            this.tempFile = File.createTempFile(this.temp_prefix, this.temp_postfix);
            this.tempFile.deleteOnExit();
            LOG.debug("Writing to temporary file: " + this.tempFile.getName());
            this.strBuffer = new FileOutputStream(this.tempFile);
            this.strBuffer.write(this.baBuffer.toByteArray());
            this.os = this.strBuffer;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.os == null) {
            throw new IOException("No stream to write to");
        }
        this.os.write(b);
        if (this.baBuffer != null && this.baBuffer.size() > this.maxMemorySize) {
            this.writeSwitch();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.os == null) {
            throw new IOException("No stream to write to");
        }
        this.os.write(b, off, len);
        if (this.baBuffer != null && this.baBuffer.size() > this.maxMemorySize) {
            this.writeSwitch();
        }
    }

    public void write(InputStream is) throws IOException {
        this.write(is, -1L);
    }

    public void write(InputStream is, long lengthHint) throws IOException {
        if (this.os == null) {
            throw new IOException("No stream to write to");
        }
        byte[] buffer = new byte[this.maxChunkSize];
        long off = 0L;
        int count = 0;
        do {
            if ((count = is.read(buffer)) > 0) {
                this.os.write(buffer, 0, count);
                off += (long)count;
            }
            if (this.baBuffer == null || this.baBuffer.size() <= this.maxMemorySize) continue;
            this.writeSwitch();
        } while (count != -1 && (lengthHint <= 0L || off < lengthHint));
    }

    public InputStream getByteStream() throws IOException {
        if (this.os != null) {
            this.close();
        }
        InputStream result = null;
        if (this.tempFile != null) {
            result = new BufferedInputStream(new FileInputStream(this.tempFile), 655360);
        } else if (this.tempBuffer != null) {
            result = new ByteArrayInputStream(this.tempBuffer);
        }
        return result;
    }

    public Object getContent() {
        try {
            if (this.os != null) {
                this.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.tempFile != null ? this.tempFile : (Object)this.tempBuffer;
    }

    public File toFile() throws IOException {
        this.writeSwitch();
        if (this.os != null) {
            this.close();
        }
        File retFile = this.tempFile;
        this.tempFile = null;
        return retFile;
    }

    public void writeToStream(OutputStream out) throws IOException {
        Object result = null;
        if (this.tempFile != null) {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.tempFile));
            IOUtils.copy((InputStream)input, (OutputStream)out);
            IOUtils.closeQuietly((InputStream)input);
        } else if (this.tempBuffer != null) {
            out.write(this.tempBuffer);
        }
    }
}

