/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import com.evolvedbinary.j8fu.Either;
import com.evolvedbinary.j8fu.function.SupplierE;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.EXistInputSource;
import org.exist.util.VirtualTempFile;

public class VirtualTempFileInputSource
extends EXistInputSource {
    private static final Logger LOG = LogManager.getLogger(VirtualTempFileInputSource.class);
    private Optional<Either<Path, VirtualTempFile>> file = Optional.empty();

    public VirtualTempFileInputSource(VirtualTempFile vtempFile) throws IOException {
        this(vtempFile, null);
    }

    public VirtualTempFileInputSource(VirtualTempFile vtempFile, String encoding) throws IOException {
        vtempFile.close();
        this.file = Optional.of(Either.Right((Object)vtempFile));
        if (encoding != null) {
            super.setEncoding(encoding);
        }
        if (vtempFile.tempFile != null) {
            super.setSystemId(vtempFile.tempFile.toURI().toASCIIString());
        }
    }

    public VirtualTempFileInputSource(Path file) {
        this(file, null);
    }

    public VirtualTempFileInputSource(Path file, String encoding) {
        this.file = Optional.ofNullable(file).map(Either::Left);
        if (encoding != null) {
            super.setEncoding(encoding);
        }
        if (file != null) {
            super.setSystemId(file.toUri().toASCIIString());
        }
    }

    @Override
    public InputStream getByteStream() {
        this.assertOpen();
        return this.file.flatMap(f -> (Optional)f.fold(this::newInputStream, this::vtfByteStream)).orElse(null);
    }

    private Optional<Reader> inputStreamReader(InputStream is, String encoding) {
        return Optional.ofNullable(encoding).flatMap(e -> Optional.ofNullable(is).flatMap(i -> {
            try {
                return Optional.of(new InputStreamReader((InputStream)i, (String)e));
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
                return Optional.empty();
            }
        }));
    }

    @Override
    public Reader getCharacterStream() {
        this.assertOpen();
        return this.inputStreamReader(this.getByteStream(), this.getEncoding()).orElse(null);
    }

    @Override
    public void setByteStream(InputStream is) {
        this.assertOpen();
    }

    @Override
    public void setCharacterStream(Reader r) {
        this.assertOpen();
    }

    @Override
    public void setSystemId(String systemId) {
        this.assertOpen();
    }

    @Override
    public String getSymbolicPath() {
        this.assertOpen();
        return this.file.flatMap(f -> (Optional)f.fold(l -> Optional.of(l.toAbsolutePath().toString()), r -> Optional.ofNullable(r.tempFile).map(File::getAbsolutePath))).orElse(null);
    }

    @Override
    public long getByteStreamLength() {
        this.assertOpen();
        return this.file.flatMap(f -> (Optional)f.fold(this::fileSize, this::vtfSize)).orElse(-1L);
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            try {
                this.file.ifPresent(f -> {
                    Boolean cfr_ignored_0 = (Boolean)f.fold(l -> true, VirtualTempFile::delete);
                });
                this.file = Optional.empty();
            }
            finally {
                super.close();
            }
        }
    }

    private Optional<InputStream> newInputStream(Path path) {
        return this.safeIO(() -> new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
    }

    private Optional<InputStream> vtfByteStream(VirtualTempFile vtf) {
        return this.safeIO(() -> vtf.getByteStream());
    }

    private Optional<Long> fileSize(Path path) {
        return this.safeIO(() -> Files.size(path));
    }

    private <T> Optional<T> safeIO(SupplierE<T, IOException> isSource) {
        try {
            return Optional.of(isSource.get());
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return Optional.empty();
        }
    }

    private Optional<Long> vtfSize(VirtualTempFile vtf) {
        return Optional.of(vtf.length());
    }
}

