/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.EXistInputSource;

public final class ZipEntryInputSource
extends EXistInputSource {
    private static final Logger LOG = LogManager.getLogger(ZipEntryInputSource.class);
    private final ZipEntry zipEntry;
    private final ZipFile zipFile;

    public ZipEntryInputSource(ZipFile zipFile, ZipEntry zipEntry) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
    }

    @Override
    public InputStream getByteStream() {
        this.assertOpen();
        try {
            return this.zipFile.getInputStream(this.zipEntry);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Override
    public void setByteStream(InputStream is) {
        this.assertOpen();
    }

    @Override
    public void setCharacterStream(Reader r) {
        this.assertOpen();
    }

    @Override
    public long getByteStreamLength() {
        this.assertOpen();
        return this.zipEntry.getSize();
    }

    @Override
    public String getSymbolicPath() {
        this.assertOpen();
        return this.zipFile.getName() + "#" + this.zipEntry.getName();
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            super.close();
        }
    }
}

