/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.exist.util.hashtable.AbstractHashSet;
import org.exist.util.hashtable.AbstractHashtable;

@NotThreadSafe
public class Int2ObjectHashMap<V>
extends AbstractHashtable<Integer, V> {
    private static final double DEFAULT_GROWTH_FACTOR = 1.5;
    protected int[] keys;
    protected V[] values;
    private final double growthFactor;

    public Int2ObjectHashMap() {
        this.keys = new int[this.tabSize];
        this.values = new Object[this.tabSize];
        this.growthFactor = 1.5;
    }

    public Int2ObjectHashMap(int iSize) {
        this(iSize, 1.5);
    }

    public Int2ObjectHashMap(int iSize, double growth) {
        super(iSize);
        this.keys = new int[this.tabSize];
        this.values = new Object[this.tabSize];
        this.growthFactor = growth;
    }

    public void clear() {
        this.items = 0;
        this.keys = new int[this.tabSize];
        this.values = new Object[this.tabSize];
    }

    public void put(int key, V value) {
        try {
            this.insert(key, value);
        }
        catch (AbstractHashSet.HashSetOverflowException e) {
            int[] copyKeys = this.keys;
            V[] copyValues = this.values;
            this.tabSize = (int)Int2ObjectHashMap.nextPrime((int)((double)this.tabSize * this.growthFactor));
            this.keys = new int[this.tabSize];
            this.values = new Object[this.tabSize];
            this.items = 0;
            for (int k = 0; k < copyValues.length; ++k) {
                if (copyValues[k] == null || copyValues[k] == REMOVED) continue;
                this.put(copyKeys[k], copyValues[k]);
            }
            this.put(key, value);
        }
    }

    public V get(int key) {
        int idx = Int2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        if (this.keys[idx] == key) {
            if (this.values[idx] == REMOVED) {
                return null;
            }
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (this.keys[idx] != key) continue;
            if (this.values[idx] == REMOVED) {
                return null;
            }
            return this.values[idx];
        }
        return null;
    }

    public boolean containsKey(int key) {
        int idx = Int2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return false;
        }
        if (this.keys[idx] == key) {
            return this.values[idx] != REMOVED;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return false;
            }
            if (this.keys[idx] != key) continue;
            return this.values[idx] != REMOVED;
        }
        return false;
    }

    public Object remove(int key) {
        int idx = Int2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        if (this.keys[idx] == key) {
            if (this.values[idx] == REMOVED) {
                return null;
            }
            V o = this.values[idx];
            this.values[idx] = REMOVED;
            --this.items;
            return o;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (this.keys[idx] != key) continue;
            if (this.values[idx] == REMOVED) {
                return null;
            }
            V o = this.values[idx];
            this.values[idx] = REMOVED;
            --this.items;
            return o;
        }
        return null;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Int2ObjectIterator<Integer>(AbstractHashSet.IteratorType.KEYS);
    }

    @Override
    public Iterator<V> valueIterator() {
        return new Int2ObjectIterator(AbstractHashSet.IteratorType.VALUES);
    }

    private void insert(int key, V value) throws AbstractHashSet.HashSetOverflowException {
        if (value == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = Int2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.values[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = value;
            ++this.items;
            return;
        }
        if (this.values[idx] == REMOVED) {
            bucket = idx;
        } else if (this.keys[idx] == key) {
            this.values[idx] = value;
            return;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
            } else {
                if (this.values[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    this.values[idx] = value;
                    ++this.items;
                    return;
                }
                if (this.keys[idx] == key) {
                    this.values[idx] = value;
                    return;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            this.values[bucket] = value;
            ++this.items;
            return;
        }
        throw new AbstractHashSet.HashSetOverflowException();
    }

    private boolean hasEqualKeys(Int2ObjectHashMap<?> other) {
        for (int idx = 0; idx < this.tabSize; ++idx) {
            if (this.values[idx] == null || this.values[idx] == REMOVED || other.containsKey(this.keys[idx])) continue;
            return false;
        }
        return true;
    }

    private int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    private static int hash(int i) {
        return i;
    }

    public class Int2ObjectIterator<T>
    extends AbstractHashSet.AbstractHashSetIterator<T> {
        private int idx;

        public Int2ObjectIterator(AbstractHashSet.IteratorType type) {
            super(type);
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.idx == Int2ObjectHashMap.this.tabSize) {
                return false;
            }
            while (Int2ObjectHashMap.this.values[this.idx] == null || Int2ObjectHashMap.this.values[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != Int2ObjectHashMap.this.tabSize) continue;
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.idx == Int2ObjectHashMap.this.tabSize) {
                return null;
            }
            while (Int2ObjectHashMap.this.values[this.idx] == null || Int2ObjectHashMap.this.values[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != Int2ObjectHashMap.this.tabSize) continue;
                return null;
            }
            switch (this.returnType) {
                case VALUES: {
                    return (T)Int2ObjectHashMap.this.values[this.idx++];
                }
                case KEYS: {
                    return (T)Integer.valueOf(Int2ObjectHashMap.this.keys[this.idx++]);
                }
            }
            throw new IllegalStateException("This never happens");
        }

        @Override
        public void remove() {
            if (this.idx == 0) {
                throw new IllegalStateException("remove called before next");
            }
            Int2ObjectHashMap.this.values[this.idx - 1] = AbstractHashSet.REMOVED;
            --Int2ObjectHashMap.this.items;
        }
    }
}

