/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.exist.dom.QName;

@ThreadSafe
public class NamePool {
    private final ConcurrentMap<WrappedQName, QName> pool = new ConcurrentHashMap<WrappedQName, QName>();

    public QName getSharedName(QName name) {
        WrappedQName wrapped = new WrappedQName(name);
        QName sharedName = this.pool.putIfAbsent(wrapped, name);
        if (sharedName == null) {
            return name;
        }
        return sharedName;
    }

    private static class WrappedQName
    implements Comparable<WrappedQName> {
        private final QName qname;

        public WrappedQName(QName qname) {
            this.qname = qname;
        }

        @Override
        public int compareTo(WrappedQName other) {
            if (this.qname.getNameType() != other.qname.getNameType()) {
                return this.qname.getNameType() < other.qname.getNameType() ? -1 : 1;
            }
            int c = this.qname.getNamespaceURI() == null ? (other.qname.getNamespaceURI() == null ? 0 : -1) : (other.qname.getNamespaceURI() == null ? 1 : other.qname.getNamespaceURI().compareTo(other.qname.getNamespaceURI()));
            return c == 0 ? this.qname.getLocalPart().compareTo(other.qname.getLocalPart()) : c;
        }

        public int hashCode() {
            int h = this.qname.getNameType() + 31 + this.qname.getLocalPart().hashCode();
            h += 31 * h + (this.qname.getNamespaceURI() == null ? 1 : this.qname.getNamespaceURI().hashCode());
            h += 31 * h + (this.qname.getPrefix() == null ? 1 : this.qname.getPrefix().hashCode());
            return h;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof WrappedQName)) {
                return false;
            }
            WrappedQName other = (WrappedQName)obj;
            int cmp = this.compareTo(other);
            if (cmp != 0) {
                return false;
            }
            if (this.qname.getPrefix() == null) {
                return other.qname.getPrefix() == null;
            }
            if (other.qname.getPrefix() == null) {
                return false;
            }
            return this.qname.getPrefix().equals(other.qname.getPrefix());
        }
    }
}

