/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.exist.util.hashtable.AbstractHashSet;
import org.exist.util.hashtable.AbstractHashtable;

@NotThreadSafe
public class Object2LongHashMap<K>
extends AbstractHashtable<K, Long> {
    protected K[] keys;
    protected long[] values;

    Object2LongHashMap() {
        this.keys = new Object[this.tabSize];
        this.values = new long[this.tabSize];
    }

    public Object2LongHashMap(int iSize) {
        super(iSize);
        this.keys = new Object[this.tabSize];
        this.values = new long[this.tabSize];
    }

    public void put(K key, long value) {
        try {
            this.insert(key, value);
        }
        catch (AbstractHashSet.HashSetOverflowException e) {
            K[] copyKeys = this.keys;
            long[] copyValues = this.values;
            this.tabSize = (int)Object2LongHashMap.nextPrime(this.tabSize + this.tabSize / 2);
            this.keys = new Object[this.tabSize];
            this.values = new long[this.tabSize];
            this.items = 0;
            for (int k = 0; k < copyValues.length; ++k) {
                if (copyKeys[k] == null || copyKeys[k] == REMOVED) continue;
                this.put(copyKeys[k], copyValues[k]);
            }
            this.put(key, value);
        }
    }

    public long get(K key) {
        int idx = Object2LongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return -1L;
        }
        if (this.keys[idx].equals(key)) {
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return -1L;
            }
            if (this.keys[idx] == REMOVED || !this.keys[idx].equals(key)) continue;
            return this.values[idx];
        }
        return -1L;
    }

    public boolean containsKey(K key) {
        int idx = Object2LongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return false;
        }
        if (this.keys[idx].equals(key)) {
            return true;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return false;
            }
            if (!this.keys[idx].equals(key)) continue;
            return true;
        }
        return false;
    }

    public long remove(K key) {
        int idx = Object2LongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return -1L;
        }
        if (this.keys[idx].equals(key)) {
            this.keys[idx] = REMOVED;
            --this.items;
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return -1L;
            }
            if (!this.keys[idx].equals(key)) continue;
            this.keys[idx] = REMOVED;
            --this.items;
            return this.values[idx];
        }
        return -1L;
    }

    @Override
    public Iterator<K> iterator() {
        return new Object2LongIterator(AbstractHashSet.IteratorType.KEYS);
    }

    @Override
    public Iterator<Long> valueIterator() {
        return new Object2LongIterator<Long>(AbstractHashSet.IteratorType.VALUES);
    }

    public Iterator<K> stableIterator() {
        return new Object2LongStableIterator(AbstractHashSet.IteratorType.KEYS);
    }

    protected void insert(K key, long value) throws AbstractHashSet.HashSetOverflowException {
        if (key == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = Object2LongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.keys[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = value;
            ++this.items;
            return;
        }
        if (this.keys[idx] == REMOVED) {
            bucket = idx;
        } else if (this.keys[idx].equals(key)) {
            this.values[idx] = value;
            return;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
            } else {
                if (this.keys[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    this.values[idx] = value;
                    ++this.items;
                    return;
                }
                if (this.keys[idx].equals(key)) {
                    this.values[idx] = value;
                    return;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            this.values[bucket] = value;
            ++this.items;
            return;
        }
        throw new AbstractHashSet.HashSetOverflowException();
    }

    int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    static int hash(Object o) {
        return o.hashCode();
    }

    public class Object2LongStableIterator<T>
    extends AbstractHashSet.AbstractHashSetIterator<T> {
        private final K[] mKeys;
        private final long[] mValues;
        private int idx;

        public Object2LongStableIterator(AbstractHashSet.IteratorType type) {
            super(type);
            this.idx = 0;
            this.mKeys = new Object[Object2LongHashMap.this.tabSize];
            System.arraycopy(Object2LongHashMap.this.keys, 0, this.mKeys, 0, Object2LongHashMap.this.tabSize);
            this.mValues = new long[Object2LongHashMap.this.tabSize];
            System.arraycopy(Object2LongHashMap.this.values, 0, this.mValues, 0, Object2LongHashMap.this.tabSize);
        }

        @Override
        public boolean hasNext() {
            if (this.idx == Object2LongHashMap.this.tabSize) {
                return false;
            }
            while (this.mKeys[this.idx] == null || this.mKeys[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != Object2LongHashMap.this.tabSize) continue;
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.idx == Object2LongHashMap.this.tabSize) {
                return null;
            }
            while (this.mKeys[this.idx] == null || this.mKeys[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != Object2LongHashMap.this.tabSize) continue;
                return null;
            }
            switch (this.returnType) {
                case KEYS: {
                    return (T)this.mKeys[this.idx++];
                }
                case VALUES: {
                    return (T)Long.valueOf(this.mValues[this.idx++]);
                }
            }
            throw new IllegalStateException("This never happens");
        }
    }

    public class Object2LongIterator<T>
    extends AbstractHashSet.AbstractHashSetIterator<T> {
        private int idx;

        public Object2LongIterator(AbstractHashSet.IteratorType type) {
            super(type);
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.idx == Object2LongHashMap.this.tabSize) {
                return false;
            }
            while (Object2LongHashMap.this.keys[this.idx] == null || Object2LongHashMap.this.keys[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != Object2LongHashMap.this.tabSize) continue;
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.idx == Object2LongHashMap.this.tabSize) {
                return null;
            }
            while (Object2LongHashMap.this.keys[this.idx] == null || Object2LongHashMap.this.keys[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != Object2LongHashMap.this.tabSize) continue;
                return null;
            }
            switch (this.returnType) {
                case KEYS: {
                    return (T)Object2LongHashMap.this.keys[this.idx++];
                }
                case VALUES: {
                    return (T)Long.valueOf(Object2LongHashMap.this.values[this.idx++]);
                }
            }
            throw new IllegalStateException("This never happens");
        }
    }
}

