/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.exist.util.hashtable.AbstractHashSet;
import org.exist.util.hashtable.AbstractHashtable;

@NotThreadSafe
public class SequencedLongHashMap<V>
extends AbstractHashtable<Long, V> {
    private long[] keys = new long[this.tabSize];
    private Entry<V>[] values = new Entry[this.tabSize];
    private Entry<V> first = null;
    private Entry<V> last = null;

    SequencedLongHashMap() {
    }

    public SequencedLongHashMap(int iSize) {
        super(iSize);
    }

    public void put(long key, V value) {
        Entry entry = this.insert(key, value);
        if (this.first == null) {
            this.first = entry;
            this.last = this.first;
        } else {
            this.last.next = entry;
            entry.prev = this.last;
            this.last = entry;
        }
    }

    protected Entry insert(long key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = SequencedLongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = new Entry<V>(key, value);
            ++this.items;
            return this.values[idx];
        }
        Entry<V> next = this.values[idx];
        while (next != null) {
            if (next.key == key) {
                next.value = value;
                this.removeEntry(next);
                return next;
            }
            next = next.nextDup;
        }
        next = new Entry<V>(key, value);
        next.nextDup = this.values[idx];
        this.values[idx].prevDup = next;
        this.values[idx] = next;
        ++this.items;
        return next;
    }

    public V get(long key) {
        int idx = SequencedLongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        Entry<V> next = this.values[idx];
        while (next != null) {
            if (next.key == key) {
                return next.value;
            }
            next = next.nextDup;
        }
        return null;
    }

    public Entry<V> getFirstEntry() {
        return this.first;
    }

    public V remove(long key) {
        Entry<V> entry = this.removeFromHashtable(key);
        if (entry != null) {
            this.removeEntry(entry);
            return entry.value;
        }
        return null;
    }

    private Entry<V> removeFromHashtable(long key) {
        int idx = SequencedLongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        Entry<V> next = this.values[idx];
        while (next != null) {
            if (next.key == key) {
                if (next.prevDup == null) {
                    this.values[idx] = next.nextDup;
                    if (this.values[idx] != null) {
                        this.values[idx].prevDup = null;
                    }
                } else {
                    next.prevDup.nextDup = next.nextDup;
                    if (next.nextDup != null) {
                        next.nextDup.prevDup = next.prevDup;
                    }
                }
                --this.items;
                return next;
            }
            next = next.nextDup;
        }
        return null;
    }

    public Entry<V> removeFirst() {
        if (this.first == null) {
            return null;
        }
        Entry<V> head = this.first;
        this.removeFromHashtable(this.first.key);
        this.removeEntry(this.first);
        return head;
    }

    private void removeEntry(Entry<V> entry) {
        if (entry.prev == null) {
            if (entry.next == null) {
                this.first = null;
                this.last = null;
            } else {
                entry.next.prev = null;
                this.first = entry.next;
            }
        } else {
            entry.prev.next = entry.next;
            if (entry.next == null) {
                this.last = entry.prev;
            } else {
                entry.next.prev = entry.prev;
            }
        }
        entry.prev = null;
        entry.next = null;
    }

    public void clear() {
        for (int i = 0; i < this.tabSize; ++i) {
            this.values[i] = null;
        }
        this.items = 0;
        this.first = null;
        this.last = null;
    }

    protected static int hash(long l) {
        return (int)(l ^ l >>> 32);
    }

    @Override
    public Iterator<Long> iterator() {
        return new SequencedLongIterator<Long>(AbstractHashSet.IteratorType.KEYS);
    }

    @Override
    public Iterator<V> valueIterator() {
        return new SequencedLongIterator(AbstractHashSet.IteratorType.VALUES);
    }

    public class SequencedLongIterator<T>
    extends AbstractHashSet.AbstractHashSetIterator<T> {
        private Entry<V> current;

        public SequencedLongIterator(AbstractHashSet.IteratorType type) {
            super(type);
            this.current = SequencedLongHashMap.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            if (this.current == null) {
                return null;
            }
            Entry next = this.current;
            this.current = this.current.next;
            switch (this.returnType) {
                case KEYS: {
                    return (T)Long.valueOf(next.key);
                }
                case VALUES: {
                    return (T)next.value;
                }
            }
            throw new IllegalStateException("This never happens");
        }
    }

    public static final class Entry<V> {
        final long key;
        V value;
        Entry<V> next = null;
        Entry<V> prev = null;
        Entry<V> prevDup = null;
        Entry<V> nextDup = null;

        public Entry(long key, V value) {
            this.key = key;
            this.value = value;
        }

        public Entry<V> getNext() {
            return this.next;
        }

        public long getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public String toString() {
            return Long.toString(this.key);
        }
    }
}

