/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.exist.util.io.CachingFilterInputStream;
import org.exist.util.io.FilterInputStreamCache;
import org.exist.util.io.FilterInputStreamCacheMonitor;

public abstract class AbstractFilterInputStreamCache
extends FilterInputStream
implements FilterInputStreamCache {
    private int sharedReferenceCount = 0;
    private int srcOffset = 0;
    private final InputStream src;
    private boolean srcClosed = false;

    public AbstractFilterInputStreamCache(InputStream src) {
        super(src);
        this.src = src;
        this.incrementSharedReferences();
        if (src instanceof CachingFilterInputStream) {
            FilterInputStreamCache otherCache = ((CachingFilterInputStream)src).getCache();
            otherCache.incrementSharedReferences();
        }
    }

    @Override
    public int getSrcOffset() {
        return this.srcOffset;
    }

    @Override
    public boolean isSrcClosed() {
        return this.srcClosed;
    }

    @Override
    public int available() throws IOException {
        if (this.srcClosed) {
            return 0;
        }
        return this.src.available() + this.getLength();
    }

    @Override
    public void close() throws IOException {
        this.decrementSharedReferences();
        if (this.sharedReferenceCount <= 0) {
            if (!this.srcClosed) {
                try {
                    this.src.close();
                }
                finally {
                    this.srcClosed = true;
                }
            }
            this.invalidate();
            FilterInputStreamCacheMonitor.getInstance().deregister(this);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.srcClosed) {
            throw new IOException("The underlying InputStream has been closed");
        }
        int data = this.src.read();
        if (data == -1) {
            return -1;
        }
        this.write(data);
        ++this.srcOffset;
        return data;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.srcClosed) {
            throw new IOException("The underlying InputStream has been closed");
        }
        int srcLen = this.src.read(b, off, len);
        if (srcLen == -1) {
            return -1;
        }
        this.write(b, off, srcLen);
        this.srcOffset += srcLen;
        return srcLen;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.srcClosed) {
            throw new IOException("The underlying InputStream has been closed");
        }
        if (n < 1L) {
            return 0L;
        }
        if ((long)this.srcOffset < n) {
            byte[] skipped = new byte[(int)(n - (long)this.srcOffset)];
            int srcLen = this.src.read(skipped);
            if (srcLen == -1) {
                return this.srcOffset;
            }
            this.srcOffset += srcLen;
            this.write(skipped, 0, srcLen);
            return this.srcOffset;
        }
        byte[] skipped = new byte[(int)n];
        int actualLen = this.src.read(skipped);
        this.srcOffset += actualLen;
        this.write(skipped, 0, actualLen);
        return actualLen;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported.");
    }

    @Override
    public boolean srcIsFilterInputStreamCache() {
        return this.src instanceof CachingFilterInputStream;
    }

    @Override
    public void incrementSharedReferences() {
        ++this.sharedReferenceCount;
    }

    @Override
    public void decrementSharedReferences() {
        --this.sharedReferenceCount;
    }
}

