/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.exist.util.io.ByteBufferAccessor;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBufferAccessor bufAccessor;
    private boolean closed = false;
    private static final int END_OF_STREAM = -1;

    public ByteBufferInputStream(ByteBufferAccessor bufAccessor) {
        this.bufAccessor = bufAccessor;
    }

    @Override
    public int available() throws IOException {
        int available = 0;
        if (!this.closed) {
            available = this.bufAccessor.getBuffer().capacity() - this.bufAccessor.getBuffer().position();
        }
        return available;
    }

    @Override
    public int read() throws IOException {
        this.isClosed();
        if (this.available() == 0) {
            return -1;
        }
        return this.bufAccessor.getBuffer().get();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.isClosed();
        if (this.available() == 0) {
            return -1;
        }
        if (b.length > this.available()) {
            return this.read(b, 0, this.available());
        }
        int currentPosition = this.bufAccessor.getBuffer().position();
        return this.bufAccessor.getBuffer().get(b).position() - currentPosition;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.isClosed();
        if (this.available() == 0) {
            return -1;
        }
        if (len > this.available()) {
            len = this.available();
        }
        int currentPosition = this.bufAccessor.getBuffer().position();
        return this.bufAccessor.getBuffer().get(b, off, len).position() - currentPosition;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int i) {
        this.bufAccessor.getBuffer().mark();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.bufAccessor.getBuffer().reset();
    }

    @Override
    public long skip(long l) throws IOException {
        if (l > (long)this.available()) {
            l = this.available();
        }
        long newPosition = this.bufAccessor.getBuffer().position();
        newPosition += l;
        try {
            this.bufAccessor.getBuffer().position((int)newPosition);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Unable to skip " + l + " bytes", iae);
        }
        return l;
    }

    @Override
    public void close() throws IOException {
        this.isClosed();
        this.bufAccessor.getBuffer().clear();
        this.closed = true;
    }

    private void isClosed() throws IOException {
        if (this.closed) {
            throw new IOException("The stream was previously closed");
        }
    }
}

