/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import org.exist.util.io.AbstractFilterInputStreamCache;
import org.exist.util.io.TemporaryFileManager;

public class FileFilterInputStreamCache
extends AbstractFilterInputStreamCache {
    private final Path tempFile;
    private final boolean externalFile;
    private int length = 0;
    private int offset = 0;
    private final RandomAccessFile raf;

    public FileFilterInputStreamCache(InputStream src) throws IOException {
        this(src, null);
    }

    public FileFilterInputStreamCache(InputStream src, Path f) throws IOException {
        super(src);
        if (f == null) {
            this.tempFile = TemporaryFileManager.getInstance().getTemporaryFile();
            this.externalFile = false;
        } else {
            this.tempFile = f;
            this.externalFile = true;
        }
        this.raf = new RandomAccessFile(this.tempFile.toFile(), "rw");
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.offset != this.length) {
            this.raf.seek(this.length);
            this.offset = this.length;
        }
        this.raf.write(b, off, len);
        this.length += len;
        this.offset += len;
    }

    @Override
    public void write(int i) throws IOException {
        if (this.offset != this.length) {
            this.raf.seek(this.length);
            this.offset = this.length;
        }
        this.raf.write(i);
        ++this.length;
        ++this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public byte get(int off) throws IOException {
        if (off != this.offset) {
            this.raf.seek(off);
            this.offset = off;
        }
        byte b = this.raf.readByte();
        ++this.offset;
        return b;
    }

    @Override
    public void copyTo(int cacheOffset, byte[] b, int off, int len) throws IOException {
        if (cacheOffset != this.offset) {
            this.raf.seek(cacheOffset);
            this.offset = cacheOffset;
        }
        this.raf.readFully(b, off, len);
        this.offset += len;
    }

    @Override
    public void invalidate() throws IOException {
        this.raf.close();
        if (this.tempFile != null && !this.externalFile) {
            TemporaryFileManager.getInstance().returnTemporaryFile(this.tempFile);
        }
    }

    public Path getFilePath() {
        return this.tempFile;
    }
}

