/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import org.exist.util.io.AbstractFilterInputStreamCache;
import org.exist.util.io.TemporaryFileManager;

public class MemoryMappedFileFilterInputStreamCache
extends AbstractFilterInputStreamCache {
    private static final long DEFAULT_MEMORY_MAP_SIZE = 0x4000000L;
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private MappedByteBuffer buf;
    private Path tempFile = null;
    private final long memoryMapSize = 0x4000000L;
    private boolean externalFile = true;

    public MemoryMappedFileFilterInputStreamCache(InputStream src) throws IOException {
        this(src, null);
    }

    public MemoryMappedFileFilterInputStreamCache(InputStream src, Path f) throws IOException {
        super(src);
        if (f == null) {
            this.tempFile = TemporaryFileManager.getInstance().getTemporaryFile();
            this.externalFile = false;
        } else {
            this.tempFile = f;
            this.externalFile = true;
        }
        this.raf = new RandomAccessFile(this.tempFile.toFile(), "rw");
        this.channel = this.raf.getChannel();
        this.buf = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.getMemoryMapSize());
    }

    private long getMemoryMapSize() {
        return 0x4000000L;
    }

    private void increaseSize(long bytes) throws IOException {
        long factor = bytes / this.getMemoryMapSize();
        if (factor == 0L || bytes % this.getMemoryMapSize() > 0L) {
            ++factor;
        }
        this.buf.force();
        int position = this.buf.position();
        this.buf = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, (long)this.buf.capacity() + this.getMemoryMapSize() * factor);
        this.buf.position(position);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buf.remaining() < len) {
            this.increaseSize(len - this.buf.remaining());
        }
        this.buf.put(b, off, len);
    }

    @Override
    public void write(int i) throws IOException {
        if (this.buf.remaining() < 1) {
            this.increaseSize(1L);
        }
        this.buf.put((byte)i);
    }

    @Override
    public byte get(int off) throws IOException {
        if (off > this.buf.capacity()) {
            this.increaseSize(off - this.buf.capacity());
        }
        return this.buf.get(off);
    }

    @Override
    public int getLength() {
        return this.buf.capacity() - this.buf.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(int cacheOffset, byte[] b, int off, int len) throws IOException {
        if (off + len > this.buf.capacity()) {
            this.increaseSize(off + len - this.buf.capacity());
        }
        int position = this.buf.position();
        try {
            this.buf.position(cacheOffset);
            byte[] data = new byte[len];
            this.buf.get(data, 0, len);
            System.arraycopy(data, 0, b, off, len);
        }
        finally {
            this.buf.position(position);
        }
    }

    @Override
    public void invalidate() throws IOException {
        this.buf.force();
        this.channel.close();
        this.raf.close();
        if (this.tempFile != null && !this.externalFile) {
            TemporaryFileManager.getInstance().returnTemporaryFile(this.tempFile);
        }
    }

    public Path getFilePath() {
        return this.tempFile;
    }
}

