/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.pool;

import java.util.LinkedList;
import net.jcip.annotations.ThreadSafe;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.CDATASectionImpl;
import org.exist.dom.persistent.CommentImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.NodeImpl;
import org.exist.dom.persistent.ProcessingInstructionImpl;
import org.exist.dom.persistent.TextImpl;
import org.exist.util.hashtable.Int2ObjectHashMap;

@ThreadSafe
public class NodePool {
    public static final int MAX_OBJECTS = 20;
    private static final ThreadLocal<NodePool> pools = new PoolThreadLocal();
    private int maxActive;
    private Int2ObjectHashMap<Pool> poolMap = new Int2ObjectHashMap(17);

    private NodePool(int maxObjects) {
        this.maxActive = maxObjects;
    }

    public static NodePool getInstance() {
        return pools.get();
    }

    public NodeImpl borrowNode(short key) {
        Pool pool = this.poolMap.get(key);
        if (pool == null) {
            pool = new Pool();
            this.poolMap.put(key, pool);
        }
        return pool.borrowNode(key);
    }

    public void returnNode(NodeImpl node) {
        Pool pool = this.poolMap.get(node.getNodeType());
        if (pool != null) {
            pool.returnNode(node);
        }
    }

    public int getSize(short key) {
        Pool pool = this.poolMap.get(key);
        return pool.stack.size();
    }

    private NodeImpl makeObject(short key) {
        switch (key) {
            case 1: {
                return new ElementImpl();
            }
            case 3: {
                return new TextImpl();
            }
            case 2: {
                return new AttrImpl();
            }
            case 4: {
                return new CDATASectionImpl();
            }
            case 7: {
                return new ProcessingInstructionImpl();
            }
            case 8: {
                return new CommentImpl();
            }
        }
        throw new IllegalStateException("Unable to create object of type " + key);
    }

    private class Pool {
        private LinkedList<NodeImpl> stack = new LinkedList();

        private Pool() {
        }

        public NodeImpl borrowNode(short key) {
            if (this.stack.isEmpty()) {
                return NodePool.this.makeObject(key);
            }
            return this.stack.removeLast();
        }

        public void returnNode(NodeImpl node) {
            if (this.stack.size() < NodePool.this.maxActive) {
                this.stack.addLast(node);
            }
        }
    }

    private static class PoolThreadLocal
    extends ThreadLocal<NodePool> {
        private PoolThreadLocal() {
        }

        @Override
        protected NodePool initialValue() {
            return new NodePool(20);
        }
    }
}

