/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.Writer;
import java.util.Properties;
import org.exist.util.serializer.HTML5Writer;
import org.exist.util.serializer.IndentingXMLWriter;
import org.exist.util.serializer.MicroXmlWriter;
import org.exist.util.serializer.TEXTWriter;
import org.exist.util.serializer.XHTML5Writer;
import org.exist.util.serializer.XHTMLWriter;
import org.exist.util.serializer.XMLWriter;
import org.exist.util.serializer.json.JSONWriter;

public abstract class AbstractSerializer {
    protected static final int XML_WRITER = 0;
    protected static final int XHTML_WRITER = 1;
    protected static final int TEXT_WRITER = 2;
    protected static final int JSON_WRITER = 3;
    protected static final int XHTML5_WRITER = 4;
    protected static final int MICRO_XML_WRITER = 5;
    protected static final int HTML5_WRITER = 6;
    protected XMLWriter[] writers = new XMLWriter[]{new IndentingXMLWriter(), new XHTMLWriter(), new TEXTWriter(), new JSONWriter(), new XHTML5Writer(), new MicroXmlWriter(), new HTML5Writer()};
    protected static final Properties defaultProperties = new Properties();
    protected Properties outputProperties;
    protected XMLWriter receiver = this.getDefaultWriter();

    protected XMLWriter getDefaultWriter() {
        return this.writers[0];
    }

    public void setOutput(Writer writer, Properties properties) {
        double htmlVersion;
        this.outputProperties = properties == null ? new Properties(defaultProperties) : properties;
        String method = this.outputProperties.getProperty("method", "xml");
        String htmlVersionProp = this.outputProperties.getProperty("html-version", "1.0");
        try {
            htmlVersion = Double.parseDouble(htmlVersionProp);
        }
        catch (NumberFormatException e) {
            htmlVersion = 1.0;
        }
        this.receiver = "xhtml".equalsIgnoreCase(method) ? (htmlVersion < 5.0 ? this.writers[1] : this.writers[4]) : ("html".equals(method) ? (htmlVersion < 5.0 ? this.writers[1] : this.writers[6]) : ("text".equalsIgnoreCase(method) ? this.writers[2] : ("json".equalsIgnoreCase(method) ? this.writers[3] : ("xhtml5".equalsIgnoreCase(method) ? this.writers[4] : ("html5".equalsIgnoreCase(method) ? this.writers[6] : ("microxml".equalsIgnoreCase(method) ? this.writers[5] : this.writers[0]))))));
        this.receiver.setWriter(writer);
        this.receiver.setOutputProperties(this.outputProperties);
    }

    public void reset() {
        for (XMLWriter writer : this.writers) {
            writer.reset();
        }
    }

    static {
        defaultProperties.setProperty("encoding", "UTF-8");
        defaultProperties.setProperty("indent", "false");
    }
}

