/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.storage.DBBroker;
import org.exist.util.serializer.AbstractSerializer;
import org.exist.util.serializer.AdaptiveWriter;
import org.exist.util.serializer.XMLWriter;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Sequence;
import org.xml.sax.SAXException;

public class AdaptiveSerializer
extends AbstractSerializer {
    private static final String DEFAULT_ITEM_SEPARATOR = "\n";
    private final DBBroker broker;
    private AdaptiveWriter adaptiveWriter;

    public AdaptiveSerializer(DBBroker broker) {
        this.broker = broker;
    }

    @Override
    public void setOutput(Writer writer, Properties properties) {
        this.outputProperties = properties == null ? new Properties(defaultProperties) : properties;
        for (XMLWriter w : this.writers) {
            w.setWriter(writer);
            w.setOutputProperties(this.outputProperties);
        }
        this.adaptiveWriter = new AdaptiveWriter(this.broker, this.outputProperties, this.writers[2]);
    }

    public void serialize(Sequence sequence) throws XPathException, SAXException {
        String itemSep = this.outputProperties.getProperty("item-separator", DEFAULT_ITEM_SEPARATOR);
        try {
            this.adaptiveWriter.write(sequence, itemSep, false);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }
}

