/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.util.serializer.AbstractSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMSerializer
extends AbstractSerializer {
    protected NamespaceSupport nsSupport = new NamespaceSupport();
    protected Map<String, String> namespaceDecls = new HashMap<String, String>();

    public DOMSerializer(Writer writer, Properties outputProperties) {
        this.setOutput(writer, outputProperties);
    }

    public void setWriter(Writer writer) {
        this.receiver.setWriter(writer);
    }

    @Override
    public void reset() {
        super.reset();
        this.nsSupport.reset();
        this.namespaceDecls.clear();
    }

    public void serialize(Node node) throws TransformerException {
        this.receiver.startDocument();
        Node top = node;
        while (node != null) {
            Node nextNode;
            this.startNode(node);
            Node node2 = nextNode = node.getNodeType() == 100 ? null : node.getFirstChild();
            while (nextNode == null) {
                this.endNode(node);
                if (top != null && top.equals(node)) break;
                nextNode = node.getNextSibling();
                if (nextNode != null || (node = node.getParentNode()) != null && (top == null || !top.equals(node))) continue;
                this.endNode(node);
                break;
            }
            node = nextNode;
        }
        this.receiver.endDocument();
    }

    protected void startNode(Node node) throws TransformerException {
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                break;
            }
            case 1: {
                Attr nextAttr;
                this.namespaceDecls.clear();
                this.nsSupport.pushContext();
                this.receiver.startElement(node.getNamespaceURI(), node.getLocalName(), node.getNodeName());
                String uri = node.getNamespaceURI();
                String prefix = node.getPrefix();
                if (uri == null) {
                    uri = "";
                }
                if (prefix == null) {
                    prefix = "";
                }
                if (this.nsSupport.getURI(prefix) == null) {
                    this.namespaceDecls.put(prefix, uri);
                    this.nsSupport.declarePrefix(prefix, uri);
                }
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    nextAttr = (Attr)attrs.item(i);
                    String attrName = nextAttr.getName();
                    if ("xmlns".equals(attrName)) {
                        String oldURI = this.nsSupport.getURI("");
                        uri = nextAttr.getValue();
                        if (oldURI != null && oldURI.equals(uri)) continue;
                        this.namespaceDecls.put("", uri);
                        this.nsSupport.declarePrefix("", uri);
                        continue;
                    }
                    if (attrName.startsWith("xmlns:")) {
                        prefix = attrName.substring(6);
                        if (this.nsSupport.getURI(prefix) != null) continue;
                        uri = nextAttr.getValue();
                        this.namespaceDecls.put(prefix, uri);
                        this.nsSupport.declarePrefix(prefix, uri);
                        continue;
                    }
                    if (attrName.indexOf(58) <= 0) continue;
                    prefix = nextAttr.getPrefix();
                    uri = nextAttr.getNamespaceURI();
                    if (prefix == null) {
                        prefix = attrName.split(":")[0];
                    }
                    if (this.nsSupport.getURI(prefix) != null) continue;
                    this.namespaceDecls.put(prefix, uri);
                    this.nsSupport.declarePrefix(prefix, uri);
                }
                for (Map.Entry<String, String> nsEntry : this.namespaceDecls.entrySet()) {
                    this.receiver.namespace(nsEntry.getKey(), nsEntry.getValue());
                }
                for (int i = 0; i < attrs.getLength(); ++i) {
                    nextAttr = (Attr)attrs.item(i);
                    String name = nextAttr.getName();
                    if (name.startsWith("xmlns")) continue;
                    this.receiver.attribute(nextAttr.getName(), nextAttr.getValue());
                }
                break;
            }
            case 3: 
            case 4: {
                this.receiver.characters(((CharacterData)node).getData());
                break;
            }
            case 2: {
                break;
            }
            case 7: {
                this.receiver.processingInstruction(((ProcessingInstruction)node).getTarget(), ((ProcessingInstruction)node).getData());
                break;
            }
            case 8: {
                this.receiver.comment(((Comment)node).getData());
                break;
            }
        }
    }

    protected void endNode(Node node) throws TransformerException {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 1) {
            this.nsSupport.popContext();
            this.receiver.endElement(node.getNamespaceURI(), node.getLocalName(), node.getNodeName());
        }
    }
}

