/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.ReferenceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMStreamer {
    private static final Logger LOG = LogManager.getLogger(DOMStreamer.class);
    private ContentHandler contentHandler = null;
    private LexicalHandler lexicalHandler = null;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private final Map<String, String> namespaceDecls = new HashMap<String, String>();
    private final Deque<ElementInfo> stack = new ArrayDeque<ElementInfo>();

    public DOMStreamer() {
    }

    public DOMStreamer(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public void reset() {
        this.nsSupport.reset();
        this.namespaceDecls.clear();
        this.stack.clear();
        this.contentHandler = null;
        this.lexicalHandler = null;
    }

    public void serialize(Node node) throws SAXException {
        this.serialize(node, false);
    }

    public void serialize(Node node, boolean callDocumentEvents) throws SAXException {
        if (callDocumentEvents) {
            this.contentHandler.startDocument();
        }
        Node top = node;
        while (node != null) {
            this.startNode(node);
            Node nextNode = node.getFirstChild();
            if (node instanceof ReferenceNode) {
                nextNode = null;
            }
            while (nextNode == null) {
                this.endNode(node);
                if (top != null && top.equals(node)) break;
                nextNode = node.getNextSibling();
                if (nextNode != null || (node = node.getParentNode()) != null && (top == null || !top.equals(node))) continue;
                this.endNode(node);
                break;
            }
            node = nextNode;
        }
        if (callDocumentEvents) {
            this.contentHandler.endDocument();
        }
    }

    protected void startNode(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                break;
            }
            case 1: {
                String namespaceURI;
                Attr nextAttr;
                this.namespaceDecls.clear();
                this.nsSupport.pushContext();
                String uri = node.getNamespaceURI();
                String prefix = node.getPrefix();
                if (uri == null) {
                    uri = "http://www.w3.org/XML/1998/namespace";
                }
                if (prefix == null) {
                    prefix = "";
                }
                if (this.nsSupport.getURI(prefix) == null) {
                    this.namespaceDecls.put(prefix, uri);
                    this.nsSupport.declarePrefix(prefix, uri);
                }
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    nextAttr = (Attr)attrs.item(i);
                    String attrName = nextAttr.getName();
                    if ("xmlns".equals(attrName)) {
                        if (this.nsSupport.getURI("") != null) continue;
                        uri = nextAttr.getValue();
                        this.namespaceDecls.put("", uri);
                        this.nsSupport.declarePrefix("", uri);
                        continue;
                    }
                    if (attrName.startsWith("xmlns:")) {
                        prefix = attrName.substring(6);
                        if (this.nsSupport.getURI(prefix) != null) continue;
                        uri = nextAttr.getValue();
                        this.namespaceDecls.put(prefix, uri);
                        this.nsSupport.declarePrefix(prefix, uri);
                        continue;
                    }
                    if (attrName.indexOf(58) <= 0) continue;
                    prefix = nextAttr.getPrefix();
                    if (prefix == null) {
                        prefix = "";
                    }
                    uri = nextAttr.getNamespaceURI();
                    if (this.nsSupport.getURI(prefix) != null) continue;
                    this.namespaceDecls.put(prefix, uri);
                    this.nsSupport.declarePrefix(prefix, uri);
                }
                ElementInfo info = new ElementInfo(node);
                String[] declaredPrefixes = null;
                if (this.namespaceDecls.size() > 0) {
                    declaredPrefixes = new String[this.namespaceDecls.size()];
                }
                int j = 0;
                for (Map.Entry<String, String> nsEntry : this.namespaceDecls.entrySet()) {
                    declaredPrefixes[j] = nsEntry.getKey();
                    this.contentHandler.startPrefixMapping(declaredPrefixes[j], nsEntry.getValue());
                    ++j;
                }
                info.prefixes = declaredPrefixes;
                this.stack.push(info);
                AttributesImpl saxAttrs = new AttributesImpl();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String attrLocalName;
                    nextAttr = (Attr)attrs.item(i);
                    String attrNS = nextAttr.getNamespaceURI();
                    if (attrNS == null) {
                        attrNS = "";
                    }
                    if ((attrLocalName = nextAttr.getLocalName()) == null) {
                        try {
                            attrLocalName = QName.extractLocalName(nextAttr.getNodeName());
                        }
                        catch (QName.IllegalQNameException e) {
                            throw new SAXException(e);
                        }
                    }
                    saxAttrs.addAttribute(attrNS, attrLocalName, nextAttr.getNodeName(), "CDATA", nextAttr.getValue());
                }
                String localName = node.getLocalName();
                if (localName == null) {
                    try {
                        localName = QName.extractLocalName(node.getNodeName());
                    }
                    catch (QName.IllegalQNameException e) {
                        throw new SAXException(e);
                    }
                }
                if ((namespaceURI = node.getNamespaceURI()) == null) {
                    namespaceURI = "";
                }
                this.contentHandler.startElement(namespaceURI, localName, node.getNodeName(), saxAttrs);
                break;
            }
            case 3: {
                String cdata = ((CharacterData)node).getData();
                this.contentHandler.characters(cdata.toCharArray(), 0, cdata.length());
                break;
            }
            case 4: {
                String cdata = ((CharacterData)node).getData();
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.startCDATA();
                }
                this.contentHandler.characters(cdata.toCharArray(), 0, cdata.length());
                if (this.lexicalHandler == null) break;
                this.lexicalHandler.endCDATA();
                break;
            }
            case 2: {
                break;
            }
            case 7: {
                this.contentHandler.processingInstruction(((ProcessingInstruction)node).getTarget(), ((ProcessingInstruction)node).getData());
                break;
            }
            case 8: {
                if (this.lexicalHandler == null) break;
                String cdata = ((Comment)node).getData();
                this.lexicalHandler.comment(cdata.toCharArray(), 0, cdata.length());
                break;
            }
            default: {
                LOG.error("Unknown node type: " + node.getNodeType());
            }
        }
    }

    protected void endNode(Node node) throws SAXException {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 1) {
            String namespaceURI;
            ElementInfo info = this.stack.pop();
            this.nsSupport.popContext();
            String localName = node.getLocalName();
            if (localName == null) {
                try {
                    localName = QName.extractLocalName(node.getNodeName());
                }
                catch (QName.IllegalQNameException e) {
                    throw new SAXException(e);
                }
            }
            if ((namespaceURI = node.getNamespaceURI()) == null) {
                namespaceURI = "";
            }
            this.contentHandler.endElement(namespaceURI, localName, node.getNodeName());
            if (info.prefixes != null) {
                for (int i = 0; i < info.prefixes.length; ++i) {
                    this.contentHandler.endPrefixMapping(info.prefixes[i]);
                }
            }
        }
    }

    private static class ElementInfo {
        final Node element;
        String[] prefixes = null;

        public ElementInfo(Node element) {
            this.element = element;
        }
    }
}

