/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.GrammarFactory;
import com.siemens.ct.exi.api.sax.SAXEncoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.Grammars;
import com.siemens.ct.exi.helpers.DefaultEXIFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.exist.dom.INodeHandle;
import org.exist.dom.QName;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EXISerializer
implements ContentHandler,
Receiver {
    static final String UNKNOWN_TYPE = "";
    private SAXEncoder encoder;

    public EXISerializer(OutputStream exiOutputStream) throws EXIException, IOException {
        EXIFactory exiFactory = DefaultEXIFactory.newInstance();
        this.encoder = new SAXEncoder(exiFactory);
        this.encoder.setOutputStream(exiOutputStream);
    }

    public EXISerializer(OutputStream exiOutputStream, InputStream xsdInputStream) throws EXIException, IOException {
        EXIFactory exiFactory = DefaultEXIFactory.newInstance();
        GrammarFactory grammarFactory = GrammarFactory.newInstance();
        Grammars g = grammarFactory.createGrammars(xsdInputStream);
        exiFactory.setGrammars(g);
        this.encoder = new SAXEncoder(exiFactory);
        this.encoder.setOutputStream(exiOutputStream);
    }

    @Override
    public void startDocument() throws SAXException {
        this.encoder.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.encoder.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        this.encoder.startPrefixMapping(prefix, namespaceURI);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.encoder.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(QName qname, AttrList attribs) throws SAXException {
        AttributesImpl attributes = null;
        if (attribs != null) {
            attributes = new AttributesImpl();
            for (int x = 0; x < attribs.size; ++x) {
                QName attribQName = attribs.getQName(x);
                attributes.addAttribute(attribQName.getNamespaceURI(), attribQName.getLocalPart(), attribQName.getStringValue(), UNKNOWN_TYPE, attribs.getValue(x));
            }
        }
        this.encoder.startElement(qname.getNamespaceURI(), qname.getLocalPart(), null, (Attributes)attributes);
    }

    @Override
    public void endElement(QName qname) throws SAXException {
        this.encoder.endElement(qname.getNamespaceURI(), qname.getLocalPart(), null);
    }

    @Override
    public void characters(CharSequence seq) throws SAXException {
        String sequence = seq.toString();
        this.encoder.characters(sequence.toCharArray(), 0, sequence.length());
    }

    @Override
    public void attribute(QName qname, String value) throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void cdataSection(char[] ch, int start, int len) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void documentType(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void highlightText(CharSequence seq) throws SAXException {
    }

    public void setCurrentNode(INodeHandle node) {
    }

    @Override
    public Document getDocument() {
        return null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.encoder.startElement(uri, localName, null, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.encoder.endElement(uri, localName, null);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.encoder.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    void setEncoder(SAXEncoder encoder) {
        this.encoder = encoder;
    }
}

