/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.IOException;
import java.io.Writer;
import javax.xml.transform.TransformerException;
import org.exist.dom.QName;
import org.exist.util.hashtable.ObjectHashSet;
import org.exist.util.serializer.XHTML5Writer;

public class HTML5Writer
extends XHTML5Writer {
    private static final ObjectHashSet<String> EMPTY_TAGS = new ObjectHashSet(31);
    private static final ObjectHashSet<String> RAW_TEXT_ELEMENTS;

    public HTML5Writer() {
        super(EMPTY_TAGS, INLINE_TAGS);
    }

    public HTML5Writer(Writer writer) {
        super(writer, EMPTY_TAGS, INLINE_TAGS);
    }

    @Override
    public void endElement(QName qname) throws TransformerException {
        if (!this.isEmptyTag(qname.getLocalPart())) {
            super.endElement(qname);
        } else {
            this.closeStartTag(true);
            this.endIndent(qname.getNamespaceURI(), qname.getLocalPart());
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qname) throws TransformerException {
        if (!this.isEmptyTag(localName)) {
            super.endElement(namespaceURI, localName, qname);
        } else {
            this.closeStartTag(true);
            this.endIndent(namespaceURI, localName);
        }
    }

    @Override
    public void attribute(String qname, String value) throws TransformerException {
        try {
            if (!this.tagIsOpen) {
                this.characters(value);
                return;
            }
            Writer writer = this.getWriter();
            writer.write(32);
            writer.write(qname);
            if (!qname.equals(value)) {
                writer.write("=\"");
                this.writeChars(value, true);
                writer.write(34);
            }
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public void attribute(QName qname, String value) throws TransformerException {
        try {
            if (!this.tagIsOpen) {
                this.characters(value);
                return;
            }
            Writer writer = this.getWriter();
            writer.write(32);
            if (qname.getPrefix() != null && qname.getPrefix().length() > 0) {
                writer.write(qname.getPrefix());
                writer.write(58);
            }
            if (!qname.getLocalPart().equals(value)) {
                writer.write(qname.getLocalPart());
                writer.write("=\"");
                this.writeChars(value, true);
                writer.write(34);
            }
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public void namespace(String prefix, String nsURI) throws TransformerException {
    }

    @Override
    protected void closeStartTag(boolean isEmpty) throws TransformerException {
        try {
            if (this.tagIsOpen) {
                if (isEmpty) {
                    if (this.isEmptyTag(this.currentTag)) {
                        this.getWriter().write(">");
                    } else {
                        this.getWriter().write(62);
                        this.getWriter().write("</");
                        this.getWriter().write(this.currentTag);
                        this.getWriter().write(62);
                    }
                } else {
                    this.getWriter().write(62);
                }
                this.tagIsOpen = false;
            }
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe.getMessage(), ioe);
        }
    }

    @Override
    protected boolean needsEscape(char ch) {
        if (RAW_TEXT_ELEMENTS.contains(this.currentTag)) {
            return false;
        }
        return super.needsEscape(ch);
    }

    static {
        EMPTY_TAGS.add("area");
        EMPTY_TAGS.add("base");
        EMPTY_TAGS.add("br");
        EMPTY_TAGS.add("col");
        EMPTY_TAGS.add("embed");
        EMPTY_TAGS.add("hr");
        EMPTY_TAGS.add("img");
        EMPTY_TAGS.add("input");
        EMPTY_TAGS.add("keygen");
        EMPTY_TAGS.add("link");
        EMPTY_TAGS.add("meta");
        EMPTY_TAGS.add("param");
        EMPTY_TAGS.add("source");
        EMPTY_TAGS.add("track");
        EMPTY_TAGS.add("wbr");
        RAW_TEXT_ELEMENTS = new ObjectHashSet(31);
        RAW_TEXT_ELEMENTS.add("script");
        RAW_TEXT_ELEMENTS.add("style");
        RAW_TEXT_ELEMENTS.add("textarea");
        RAW_TEXT_ELEMENTS.add("title");
    }
}

