/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.serializer.XMLWriter;

public class IndentingXMLWriter
extends XMLWriter {
    private static final Logger LOG = LogManager.getLogger(IndentingXMLWriter.class);
    private boolean indent = false;
    private int indentAmount = 4;
    private String indentChars = "                                                                                           ";
    private int level = 0;
    private boolean afterTag = false;
    private boolean sameline = false;
    private boolean whitespacePreserve = false;
    private Deque<Integer> whitespacePreserveStack = new ArrayDeque<Integer>();

    public IndentingXMLWriter() {
    }

    public IndentingXMLWriter(Writer writer) {
        super(writer);
    }

    @Override
    public void setWriter(Writer writer) {
        super.setWriter(writer);
        this.level = 0;
        this.afterTag = false;
        this.sameline = false;
        this.whitespacePreserveStack.clear();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qname) throws TransformerException {
        if (this.afterTag && !this.isInlineTag(namespaceURI, localName)) {
            this.indent();
        }
        super.startElement(namespaceURI, localName, qname);
        this.addIndent();
        this.afterTag = true;
        this.sameline = true;
    }

    @Override
    public void startElement(QName qname) throws TransformerException {
        if (this.afterTag && !this.isInlineTag(qname.getNamespaceURI(), qname.getLocalPart())) {
            this.indent();
        }
        super.startElement(qname);
        this.addIndent();
        this.afterTag = true;
        this.sameline = true;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qname) throws TransformerException {
        this.endIndent(namespaceURI, localName);
        super.endElement(namespaceURI, localName, qname);
        this.popWhitespacePreserve();
        this.sameline = this.isInlineTag(namespaceURI, localName);
        this.afterTag = true;
    }

    @Override
    public void endElement(QName qname) throws TransformerException {
        this.endIndent(qname.getNamespaceURI(), qname.getLocalPart());
        super.endElement(qname);
        this.popWhitespacePreserve();
        this.sameline = this.isInlineTag(qname.getNamespaceURI(), qname.getLocalPart());
        this.afterTag = true;
    }

    @Override
    public void characters(CharSequence chars) throws TransformerException {
        boolean start = false;
        int length = chars.length();
        if (length == 0) {
            return;
        }
        if (length < chars.length()) {
            chars = chars.subSequence(0, length);
        }
        for (int i = 0; i < chars.length(); ++i) {
            if (chars.charAt(i) != '\n') continue;
            this.sameline = false;
        }
        this.afterTag = false;
        super.characters(chars);
    }

    @Override
    public void comment(CharSequence data) throws TransformerException {
        super.comment(data);
        this.afterTag = true;
    }

    @Override
    public void processingInstruction(String target, String data) throws TransformerException {
        super.processingInstruction(target, data);
        this.afterTag = true;
    }

    @Override
    public void documentType(String name, String publicId, String systemId) throws TransformerException {
        super.documentType(name, publicId, systemId);
        super.characters("\n");
        this.sameline = false;
    }

    @Override
    public void setOutputProperties(Properties properties) {
        super.setOutputProperties(properties);
        String option = this.outputProperties.getProperty("indent-spaces", "4");
        try {
            this.indentAmount = Integer.parseInt(option);
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid indentation value: '" + option + "'");
        }
        this.indent = "yes".equals(this.outputProperties.getProperty("indent", "no"));
    }

    @Override
    public void attribute(String qname, String value) throws TransformerException {
        if ("xml:space".equals(qname)) {
            this.pushWhitespacePreserve(value);
        }
        super.attribute(qname, value);
    }

    @Override
    public void attribute(QName qname, String value) throws TransformerException {
        if ("xml".equals(qname.getPrefix()) && "space".equals(qname.getLocalPart())) {
            this.pushWhitespacePreserve(value);
        }
        super.attribute(qname, value);
    }

    protected void pushWhitespacePreserve(String value) {
        if (value.equals("preserve")) {
            this.whitespacePreserve = true;
            this.whitespacePreserveStack.push(-this.level);
        } else if (value.equals("default")) {
            this.whitespacePreserve = false;
            this.whitespacePreserveStack.push(this.level);
        }
    }

    protected void popWhitespacePreserve() {
        if (!this.whitespacePreserveStack.isEmpty() && Math.abs(this.whitespacePreserveStack.peek()) > this.level) {
            this.whitespacePreserveStack.pop();
            this.whitespacePreserve = !this.whitespacePreserveStack.isEmpty() && this.whitespacePreserveStack.peek() < 0;
        }
    }

    protected boolean isInlineTag(String namespaceURI, String localName) {
        return this.isMatchTag(namespaceURI, localName);
    }

    private boolean isMatchTag(String namespaceURI, String localName) {
        return namespaceURI != null && namespaceURI.equals("http://exist.sourceforge.net/NS/exist") && localName.equals("match");
    }

    protected void addSpaceIfIndent() throws IOException {
        if (!this.indent || this.whitespacePreserve) {
            return;
        }
        this.writer.write(32);
    }

    protected void indent() throws TransformerException {
        if (!this.indent || this.whitespacePreserve) {
            return;
        }
        int spaces = this.indentAmount * this.level;
        while (spaces >= this.indentChars.length()) {
            this.indentChars = this.indentChars + this.indentChars;
        }
        super.characters("\n");
        super.characters(this.indentChars.subSequence(0, spaces));
        this.sameline = false;
    }

    protected void addIndent() {
        ++this.level;
    }

    protected void endIndent(String namespaceURI, String localName) throws TransformerException {
        --this.level;
        if (this.afterTag && !this.sameline && !this.isInlineTag(namespaceURI, localName)) {
            this.indent();
        }
    }
}

