/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.IOException;
import java.io.Writer;
import javax.xml.transform.TransformerException;
import org.exist.dom.QName;
import org.exist.util.hashtable.ObjectHashSet;
import org.exist.util.serializer.IndentingXMLWriter;

public class XHTMLWriter
extends IndentingXMLWriter {
    protected static final ObjectHashSet<String> EMPTY_TAGS = new ObjectHashSet(31);
    protected static final ObjectHashSet<String> INLINE_TAGS;
    protected String currentTag;
    protected ObjectHashSet<String> emptyTags;
    protected ObjectHashSet<String> inlineTags;
    boolean haveCollapsedXhtmlPrefix = false;

    public XHTMLWriter() {
        this(EMPTY_TAGS, INLINE_TAGS);
    }

    public XHTMLWriter(ObjectHashSet<String> emptyTags, ObjectHashSet<String> inlineTags) {
        this.emptyTags = emptyTags;
        this.inlineTags = inlineTags;
    }

    public XHTMLWriter(Writer writer) {
        this(writer, EMPTY_TAGS, INLINE_TAGS);
    }

    public XHTMLWriter(Writer writer, ObjectHashSet<String> emptyTags, ObjectHashSet<String> inlineTags) {
        super(writer);
        this.emptyTags = emptyTags;
        this.inlineTags = inlineTags;
    }

    protected boolean isEmptyTag(String tag) {
        return this.emptyTags.contains(tag);
    }

    @Override
    public void startElement(QName qname) throws TransformerException {
        QName xhtmlQName = this.removeXhtmlPrefix(qname);
        super.startElement(xhtmlQName);
        this.currentTag = xhtmlQName.getStringValue();
    }

    @Override
    public void endElement(QName qname) throws TransformerException {
        QName xhtmlQName = this.removeXhtmlPrefix(qname);
        super.endElement(xhtmlQName);
        this.haveCollapsedXhtmlPrefix = false;
    }

    protected QName removeXhtmlPrefix(QName qname) {
        String prefix = qname.getPrefix();
        String namespaceURI = qname.getNamespaceURI();
        if (prefix != null && prefix.length() > 0 && namespaceURI != null && namespaceURI.equals("http://www.w3.org/1999/xhtml")) {
            this.haveCollapsedXhtmlPrefix = true;
            return new QName(qname.getLocalPart(), namespaceURI);
        }
        return qname;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qname) throws TransformerException {
        String xhtmlQName = this.removeXhtmlPrefix(namespaceURI, qname);
        super.startElement(namespaceURI, localName, xhtmlQName);
        this.currentTag = xhtmlQName;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qname) throws TransformerException {
        String xhtmlQName = this.removeXhtmlPrefix(namespaceURI, qname);
        super.endElement(namespaceURI, localName, xhtmlQName);
        this.haveCollapsedXhtmlPrefix = false;
    }

    protected String removeXhtmlPrefix(String namespaceURI, String qname) {
        int pos = qname.indexOf(58);
        if (pos > 0 && namespaceURI != null && namespaceURI.equals("http://www.w3.org/1999/xhtml")) {
            this.haveCollapsedXhtmlPrefix = true;
            return qname.substring(pos + 1);
        }
        return qname;
    }

    @Override
    public void namespace(String prefix, String nsURI) throws TransformerException {
        if (this.haveCollapsedXhtmlPrefix && prefix != null && prefix.length() > 0 && nsURI.equals("http://www.w3.org/1999/xhtml")) {
            return;
        }
        super.namespace(prefix, nsURI);
    }

    @Override
    protected void closeStartTag(boolean isEmpty) throws TransformerException {
        try {
            if (this.tagIsOpen) {
                if (isEmpty) {
                    if (this.isEmptyTag(this.currentTag)) {
                        this.getWriter().write(" />");
                    } else {
                        this.getWriter().write(62);
                        this.getWriter().write("</");
                        this.getWriter().write(this.currentTag);
                        this.getWriter().write(62);
                    }
                } else {
                    this.getWriter().write(62);
                }
                this.tagIsOpen = false;
            }
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe.getMessage(), ioe);
        }
    }

    @Override
    protected boolean isInlineTag(String namespaceURI, String localName) {
        return (namespaceURI == null || "".equals(namespaceURI) || "http://www.w3.org/1999/xhtml".equals(namespaceURI)) && this.inlineTags.contains(localName);
    }

    static {
        EMPTY_TAGS.add("area");
        EMPTY_TAGS.add("base");
        EMPTY_TAGS.add("br");
        EMPTY_TAGS.add("col");
        EMPTY_TAGS.add("hr");
        EMPTY_TAGS.add("img");
        EMPTY_TAGS.add("input");
        EMPTY_TAGS.add("link");
        EMPTY_TAGS.add("meta");
        EMPTY_TAGS.add("basefont");
        EMPTY_TAGS.add("frame");
        EMPTY_TAGS.add("isindex");
        EMPTY_TAGS.add("param");
        INLINE_TAGS = new ObjectHashSet(31);
        INLINE_TAGS.add("a");
        INLINE_TAGS.add("abbr");
        INLINE_TAGS.add("acronym");
        INLINE_TAGS.add("b");
        INLINE_TAGS.add("bdo");
        INLINE_TAGS.add("big");
        INLINE_TAGS.add("br");
        INLINE_TAGS.add("button");
        INLINE_TAGS.add("cite");
        INLINE_TAGS.add("code");
        INLINE_TAGS.add("del");
        INLINE_TAGS.add("dfn");
        INLINE_TAGS.add("em");
        INLINE_TAGS.add("i");
        INLINE_TAGS.add("img");
        INLINE_TAGS.add("input");
        INLINE_TAGS.add("kbd");
        INLINE_TAGS.add("label");
        INLINE_TAGS.add("q");
        INLINE_TAGS.add("samp");
        INLINE_TAGS.add("select");
        INLINE_TAGS.add("small");
        INLINE_TAGS.add("span");
        INLINE_TAGS.add("strong");
        INLINE_TAGS.add("sub");
        INLINE_TAGS.add("sup");
        INLINE_TAGS.add("textarea");
        INLINE_TAGS.add("tt");
        INLINE_TAGS.add("var");
    }
}

