/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.serializer.json.JSONNode;

public class JSONObject
extends JSONNode {
    private static final Logger LOG = LogManager.getLogger(JSONObject.class);
    protected JSONNode firstChild = null;
    private boolean asSimpleValue = false;

    public JSONObject() {
        super(JSONNode.Type.OBJECT_TYPE, "#anonymous");
    }

    public JSONObject(String name) {
        super(JSONNode.Type.OBJECT_TYPE, name);
    }

    public JSONObject(String name, boolean asSimpleValue) {
        super(JSONNode.Type.OBJECT_TYPE, name);
        this.asSimpleValue = asSimpleValue;
    }

    public void addObject(JSONNode node) {
        JSONNode childNode = this.findChild(node.getName());
        if (childNode == null) {
            childNode = this.getLastChild();
            if (childNode == null) {
                this.firstChild = node;
            } else {
                childNode.setNext(node);
            }
        } else {
            childNode.setNextOfSame(node);
        }
    }

    public JSONNode findChild(String nameToFind) {
        for (JSONNode nextNode = this.firstChild; nextNode != null; nextNode = nextNode.getNext()) {
            if (!nextNode.getName().equals(nameToFind)) continue;
            return nextNode;
        }
        return null;
    }

    public JSONNode getLastChild() {
        JSONNode nextNode = this.firstChild;
        JSONNode currentNode = null;
        while (nextNode != null) {
            currentNode = nextNode;
            nextNode = currentNode.getNext();
        }
        return currentNode;
    }

    public int getChildCount() {
        int count = 0;
        for (JSONNode nextNode = this.firstChild; nextNode != null; nextNode = nextNode.getNext()) {
            ++count;
        }
        return count;
    }

    @Override
    public void serialize(Writer writer, boolean isRoot) throws IOException {
        if (!isRoot && this.isNamed()) {
            writer.write(34);
            writer.write(this.getName());
            writer.write(34);
            if (this.isIndent()) {
                writer.write(32);
            }
            writer.write(58);
            if (this.isIndent()) {
                writer.write(32);
            }
        }
        if (this.getNextOfSame() != null || this.getSerializationType() == JSONNode.SerializationType.AS_ARRAY) {
            writer.write(91);
            JSONNode next = this;
            while (next != null) {
                ((JSONNode)next).serializeContent(writer);
                if ((next = next.getNextOfSame()) == null) continue;
                writer.write(44);
                if (!this.isIndent()) continue;
                writer.write(32);
            }
            writer.write(93);
        } else {
            this.serializeContent(writer);
        }
    }

    @Override
    public void serializeContent(Writer writer) throws IOException {
        if (this.firstChild == null) {
            if (this.getSerializationType() != JSONNode.SerializationType.AS_ARRAY) {
                writer.write("null");
            }
        } else if (this.firstChild.getNext() == null && (this.firstChild.getType() == JSONNode.Type.VALUE_TYPE || this.firstChild.isArray() && !this.firstChild.isNamed())) {
            this.firstChild.serialize(writer, false);
        } else {
            writer.write(123);
            if (this.isIndent()) {
                writer.write(32);
            }
            JSONNode next = this.firstChild;
            while (next != null) {
                if (next.getType() == JSONNode.Type.VALUE_TYPE) {
                    writer.write("\"" + next.getName() + "\"");
                    if (this.isIndent()) {
                        writer.write(32);
                    }
                    writer.write(58);
                    if (this.isIndent()) {
                        writer.write(32);
                    }
                    next.serialize(writer, false);
                } else {
                    next.serialize(writer, false);
                }
                if ((next = next.getNext()) == null) continue;
                writer.write(44);
                if (!this.isIndent()) continue;
                writer.write(32);
            }
            if (this.isIndent()) {
                writer.write(32);
            }
            writer.write(125);
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.serialize(writer, false);
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
        return writer.toString();
    }
}

