/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer.json;

import java.io.IOException;
import java.io.Writer;
import org.exist.util.serializer.json.JSONNode;

public class JSONValue
extends JSONNode {
    public static final String NAME_VALUE = "#text";
    private String content = null;

    public JSONValue(String content) {
        this(content, true);
    }

    public JSONValue(String content, boolean escape) {
        super(JSONNode.Type.VALUE_TYPE, NAME_VALUE);
        this.content = escape ? JSONValue.escape(content) : content;
    }

    public JSONValue() {
        super(JSONNode.Type.VALUE_TYPE, NAME_VALUE);
    }

    public void addContent(String str) {
        this.content = this.content == null ? str : this.content + str;
    }

    @Override
    public void serialize(Writer writer, boolean isRoot) throws IOException {
        if (this.getNextOfSame() != null) {
            writer.write(91);
            JSONNode next = this;
            while (next != null) {
                ((JSONNode)next).serializeContent(writer);
                next = next.getNextOfSame();
                if (next != null) {
                    writer.write(44);
                }
                if (!this.isIndent()) continue;
                writer.write(32);
            }
            writer.write(93);
        } else {
            this.serializeContent(writer);
        }
    }

    @Override
    public void serializeContent(Writer writer) throws IOException {
        if (this.getSerializationDataType() != JSONNode.SerializationDataType.AS_LITERAL) {
            writer.write(34);
        }
        writer.write(this.content);
        if (this.getSerializationDataType() != JSONNode.SerializationDataType.AS_LITERAL) {
            writer.write(34);
        }
    }

    protected static String escape(String str) {
        StringBuilder builder = new StringBuilder();
        block7: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    builder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    continue block7;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block7;
                }
                case '\"': {
                    builder.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    builder.append("\\\\");
                    continue block7;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        return builder.toString();
    }
}

