/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.exist.validation.ValidationReportItem;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationReport
implements ErrorHandler {
    private final List<ValidationReportItem> validationReport = new ArrayList<ValidationReportItem>();
    private ValidationReportItem lastItem;
    private long duration = -1L;
    private long start = -1L;
    private Throwable throwed = null;
    private String namespaceUri = null;

    private ValidationReportItem createValidationReportItem(int type, SAXParseException exception) {
        ValidationReportItem vri = new ValidationReportItem();
        vri.setType(type);
        vri.setLineNumber(exception.getLineNumber());
        vri.setColumnNumber(exception.getColumnNumber());
        vri.setMessage(exception.getMessage());
        vri.setPublicId(exception.getPublicId());
        vri.setSystemId(exception.getSystemId());
        return vri;
    }

    private void addItem(ValidationReportItem newItem) {
        if (this.lastItem == null) {
            this.validationReport.add(newItem);
            this.lastItem = newItem;
        } else if (this.lastItem.getMessage().equals(newItem.getMessage())) {
            this.lastItem.increaseRepeat();
        } else {
            this.validationReport.add(newItem);
            this.lastItem = newItem;
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.addItem(this.createValidationReportItem(2, exception));
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.addItem(this.createValidationReportItem(4, exception));
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.addItem(this.createValidationReportItem(1, exception));
    }

    public void setException(Throwable ex) {
        this.throwed = ex;
    }

    public boolean isValid() {
        return this.validationReport.isEmpty() && this.throwed == null;
    }

    public List<ValidationReportItem> getValidationReportItemList() {
        return this.validationReport;
    }

    public List<String> getTextValidationReport() {
        ArrayList<String> textReport = new ArrayList<String>();
        if (this.isValid()) {
            textReport.add("Document is valid.");
        } else {
            textReport.add("Document is not valid.");
        }
        if (this.throwed != null) {
            textReport.add("Exception: " + this.throwed.getMessage());
        }
        textReport.addAll(this.validationReport.stream().map(ValidationReportItem::toString).collect(Collectors.toList()));
        textReport.add("Validated in " + this.duration + " millisec.");
        return textReport;
    }

    public String[] getValidationReportArray() {
        List<String> vr = this.getTextValidationReport();
        String[] report = new String[vr.size()];
        return vr.toArray(report);
    }

    public void setValidationDuration(long time) {
        this.duration = time;
    }

    public long getValidationDuration() {
        return this.duration;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String line : this.getTextValidationReport()) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void stop() {
        if (this.getValidationDuration() == -1L) {
            long stop = System.currentTimeMillis();
            this.setValidationDuration(stop - this.start);
        }
    }

    public void setThrowable(Throwable throwable) {
        this.throwed = throwable;
    }

    public Throwable getThrowable() {
        return this.throwed;
    }

    public void setNamespaceUri(String namespace) {
        this.namespaceUri = namespace;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getStackTrace() {
        if (this.throwed == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)baos);
        this.throwed.printStackTrace(ps);
        return baos.toString();
    }
}

