/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation;

import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.validation.GrammarPool;
import org.exist.validation.ValidationContentHandler;
import org.exist.validation.ValidationReport;
import org.exist.validation.XmlLibraryChecker;
import org.exist.validation.resolver.AnyUriResolver;
import org.exist.validation.resolver.SearchResourceResolver;
import org.exist.validation.resolver.eXistXMLCatalogResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Validator {
    private static final Logger logger = LogManager.getLogger(Validator.class);
    private BrokerPool brokerPool = null;
    private GrammarPool grammarPool = null;
    private eXistXMLCatalogResolver systemCatalogResolver = null;

    public Validator(BrokerPool pool) {
        logger.info("Initializing Validator.");
        if (this.brokerPool == null) {
            this.brokerPool = pool;
        }
        Configuration config = this.brokerPool.getConfiguration();
        StringBuilder xmlLibMessage = new StringBuilder();
        if (!XmlLibraryChecker.hasValidParser(xmlLibMessage)) {
            logger.error((CharSequence)xmlLibMessage);
        }
        this.grammarPool = (GrammarPool)config.getProperty("validation.grammar_pool");
        this.systemCatalogResolver = (eXistXMLCatalogResolver)((Object)config.getProperty("validation.resolver"));
    }

    public ValidationReport validate(InputStream stream) {
        return this.validate(stream, null);
    }

    public ValidationReport validate(InputStream stream, String grammarUrl) {
        if (grammarUrl != null && grammarUrl.startsWith("/")) {
            grammarUrl = "xmldb:exist://" + grammarUrl;
        }
        if (grammarUrl != null && (grammarUrl.endsWith(".rng") || grammarUrl.endsWith(".rnc") || grammarUrl.endsWith(".nvdl") || grammarUrl.endsWith(".sch"))) {
            return this.validateJing(stream, grammarUrl);
        }
        return this.validateParse(stream, grammarUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationReport validateJing(InputStream stream, String grammarUrl) {
        ValidationReport report = new ValidationReport();
        try {
            report.start();
            PropertyMapBuilder properties = new PropertyMapBuilder();
            ValidateProperty.ERROR_HANDLER.put(properties, (Object)report);
            SchemaReader schemaReader = grammarUrl.endsWith(".rnc") ? CompactSchemaReader.getInstance() : null;
            ValidationDriver driver = new ValidationDriver(properties.toPropertyMap(), schemaReader);
            driver.loadSchema(new InputSource(grammarUrl));
            driver.validate(new InputSource(stream));
        }
        catch (IOException ex) {
            logger.error((Object)ex);
            report.setThrowable(ex);
        }
        catch (SAXException ex) {
            logger.debug((Object)ex);
            report.setThrowable(ex);
        }
        finally {
            report.stop();
        }
        return report;
    }

    public ValidationReport validateParse(InputStream stream) {
        return this.validateParse(stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationReport validateParse(InputStream stream, String grammarUrl) {
        logger.debug("Start validation.");
        ValidationReport report = new ValidationReport();
        ValidationContentHandler contenthandler = new ValidationContentHandler();
        try {
            Object resolver;
            XMLReader xmlReader = this.getXMLReader(contenthandler, report);
            if (grammarUrl == null) {
                logger.debug("Validation using system catalog.");
                xmlReader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", (Object)this.systemCatalogResolver);
            } else if (grammarUrl.endsWith(".xml")) {
                logger.debug("Validation using user specified catalog '" + grammarUrl + "'.");
                resolver = new eXistXMLCatalogResolver();
                resolver.setCatalogList(new String[]{grammarUrl});
                xmlReader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", resolver);
            } else if (grammarUrl.endsWith("/")) {
                logger.debug("Validation using searched grammar, start from '" + grammarUrl + "'.");
                resolver = new SearchResourceResolver(grammarUrl, this.brokerPool);
                xmlReader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", resolver);
            } else {
                logger.debug("Validation using specified grammar '" + grammarUrl + "'.");
                resolver = new AnyUriResolver(grammarUrl);
                xmlReader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", resolver);
            }
            logger.debug("Validation started.");
            report.start();
            InputSource source = new InputSource(stream);
            xmlReader.parse(source);
            logger.debug("Validation stopped.");
            report.stop();
            report.setNamespaceUri(contenthandler.getNamespaceUri());
            if (!report.isValid()) {
                logger.debug("Document is not valid.");
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            logger.error((Object)ex);
            report.setThrowable(ex);
        }
        finally {
            report.stop();
            logger.debug("Validation performed in " + report.getValidationDuration() + " msec.");
        }
        return report;
    }

    private XMLReader getXMLReader(ContentHandler contentHandler, ErrorHandler errorHandler) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setValidating(true);
        saxFactory.setNamespaceAware(true);
        SAXParser saxParser = saxFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", this.grammarPool);
        xmlReader.setFeature("http://xml.org/sax/features/validation", true);
        xmlReader.setFeature("http://apache.org/xml/features/validation/dynamic", false);
        xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
        xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xmlReader.setContentHandler(contentHandler);
        xmlReader.setErrorHandler(errorHandler);
        return xmlReader;
    }
}

