/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.resolver.unstable;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.protocolhandler.embedded.EmbeddedInputStream;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.storage.BrokerPool;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class ExistResolver
implements EntityResolver2,
URIResolver {
    private static final Logger LOG = LogManager.getLogger(ExistResolver.class);
    private BrokerPool brokerPool = null;
    private static final String LOCALURI = "xmldb:exist:///";
    private static final String SHORTLOCALURI = "xmldb:///";

    public ExistResolver(BrokerPool brokerPool) {
        this.brokerPool = brokerPool;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        LOG.debug("publicId=" + publicId + " systemId=" + systemId);
        return this.resolveInputSource(this.brokerPool, systemId);
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        LOG.debug("name=" + name + " baseURI=" + baseURI);
        return this.resolveInputSource(this.brokerPool, baseURI);
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        LOG.debug("name=" + name + " publicId=" + publicId + " baseURI=" + baseURI + " systemId=" + systemId);
        return this.resolveInputSource(this.brokerPool, systemId);
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        LOG.debug("href=" + href + " base=" + base);
        if (base != null) {
            int pos;
            String sep = "/";
            if (base.startsWith("file:")) {
                sep = File.separator;
            }
            if ((pos = base.lastIndexOf(sep)) != -1) {
                base = base.substring(0, pos);
                href = base + sep + href;
            }
        }
        return this.resolveStreamSource(this.brokerPool, href);
    }

    private InputSource resolveInputSource(BrokerPool bPool, String path) throws IOException {
        LOG.debug("Resolving " + path);
        InputSource inputsource = new InputSource();
        if (path != null) {
            if (path.startsWith(LOCALURI) || path.startsWith(SHORTLOCALURI)) {
                XmldbURL url = new XmldbURL(path);
                EmbeddedInputStream eis = new EmbeddedInputStream(bPool, url);
                inputsource.setByteStream(eis);
                inputsource.setSystemId(path);
            } else {
                InputStream is = new URL(path).openStream();
                inputsource.setByteStream(is);
                inputsource.setSystemId(path);
            }
        }
        return inputsource;
    }

    private StreamSource resolveStreamSource(BrokerPool bPool, String path) throws TransformerException {
        LOG.debug("Resolving " + path);
        StreamSource streamsource = new StreamSource();
        try {
            if (path != null) {
                if (path.startsWith(LOCALURI) || path.startsWith(SHORTLOCALURI)) {
                    XmldbURL url = new XmldbURL(path);
                    EmbeddedInputStream eis = new EmbeddedInputStream(bPool, url);
                    streamsource.setInputStream(eis);
                    streamsource.setSystemId(path);
                } else {
                    InputStream is = new URL(path).openStream();
                    streamsource.setInputStream(is);
                    streamsource.setSystemId(path);
                }
            }
        }
        catch (IOException ex) {
            throw new TransformerException(ex);
        }
        return streamsource;
    }
}

