/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import com.evolvedbinary.j8fu.function.FunctionE;
import java.io.IOException;
import java.util.Date;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.Permission;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.AbstractLocal;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.exist.xmldb.function.LocalXmldbDocumentFunction;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public abstract class AbstractEXistResource
extends AbstractLocal
implements EXistResource {
    protected final XmldbURI docId;
    private String mimeType = null;
    protected boolean isNewResource = false;
    protected Date datecreated = null;
    protected Date datemodified = null;

    public AbstractEXistResource(Subject user, BrokerPool pool, LocalCollection parent, XmldbURI docId, String mimeType) {
        super(user, pool, parent);
        this.docId = docId.lastSegment();
        this.mimeType = mimeType;
    }

    @Override
    public void setMimeType(String mime) {
        this.mimeType = mime;
    }

    @Override
    public String getMimeType() throws XMLDBException {
        if (this.isNewResource) {
            return this.mimeType;
        }
        return this.read((DocumentImpl document, DBBroker broker, Txn transaction) -> document.getMetadata().getMimeType());
    }

    public String getId() throws XMLDBException {
        return this.docId.toString();
    }

    public Collection getParentCollection() throws XMLDBException {
        if (this.collection == null) {
            throw new XMLDBException(201, "collection parent is null");
        }
        return this.collection;
    }

    @Override
    public Date getCreationTime() throws XMLDBException {
        return this.read((DocumentImpl document, DBBroker broker, Txn transaction) -> new Date(document.getMetadata().getCreated()));
    }

    @Override
    public Date getLastModificationTime() throws XMLDBException {
        return this.read((DocumentImpl document, DBBroker broker, Txn transaction) -> new Date(document.getMetadata().getLastModified()));
    }

    @Override
    public void setLastModificationTime(Date lastModificationTime) throws XMLDBException {
        if (lastModificationTime.before(this.getCreationTime())) {
            throw new XMLDBException(4, "Modification time must be after creation time.");
        }
        this.modify((DocumentImpl document, DBBroker broker, Txn transaction) -> {
            if (document == null) {
                throw new XMLDBException(301, "Resource " + this.docId + " not found");
            }
            document.getMetadata().setLastModified(lastModificationTime.getTime());
            return null;
        });
    }

    @Override
    public long getContentLength() throws XMLDBException {
        return this.read((DocumentImpl document, DBBroker broker, Txn transaction) -> document.getContentLength());
    }

    @Override
    public Permission getPermissions() throws XMLDBException {
        return this.read((DocumentImpl document, DBBroker broker, Txn transaction) -> document.getPermissions());
    }

    protected <R> R read(LocalXmldbDocumentFunction<R> readOp) throws XMLDBException {
        return (R)this.withDb((broker, transaction) -> this.read(broker, transaction).apply((Object)readOp));
    }

    public <R> FunctionE<LocalXmldbDocumentFunction<R>, R, XMLDBException> read(DBBroker broker, Txn transaction) throws XMLDBException {
        return this.with(Lock.LockMode.READ_LOCK, broker, transaction);
    }

    protected <R> R modify(LocalXmldbDocumentFunction<R> op) throws XMLDBException {
        return (R)this.withDb((broker, transaction) -> this.modify(broker, transaction).apply((Object)op));
    }

    public <R> FunctionE<LocalXmldbDocumentFunction<R>, R, XMLDBException> modify(DBBroker broker, Txn transaction) throws XMLDBException {
        return writeOp -> this.with(Lock.LockMode.WRITE_LOCK, broker, transaction).apply((document, broker1, transaction1) -> {
            Object result = writeOp.apply(document, broker1, transaction1);
            broker.storeXMLResource(transaction1, document);
            return result;
        });
    }

    private <R> FunctionE<LocalXmldbDocumentFunction<R>, R, XMLDBException> with(Lock.LockMode lockMode, DBBroker broker, Txn transaction) throws XMLDBException {
        return documentOp -> this.collection.with(lockMode, broker, transaction).apply((collection, broker1, transaction1) -> {
            DocumentImpl doc = null;
            try {
                doc = collection.getDocumentWithLock(broker1, this.docId, lockMode);
                if (doc == null) {
                    throw new XMLDBException(301);
                }
                Object r = documentOp.apply(doc, broker1, transaction1);
                return r;
            }
            finally {
                if (doc != null) {
                    doc.getUpdateLock().release(lockMode);
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        try {
            this.freeResources();
        }
        catch (XMLDBException e) {
            throw new IOException(e);
        }
    }
}

