/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import com.evolvedbinary.j8fu.function.FunctionE;
import org.exist.collections.Collection;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.exist.xmldb.function.LocalXmldbCollectionFunction;
import org.exist.xmldb.function.LocalXmldbFunction;
import org.xmldb.api.base.XMLDBException;

public abstract class AbstractLocal {
    protected final BrokerPool brokerPool;
    protected final Subject user;
    protected LocalCollection collection;

    AbstractLocal(Subject user, BrokerPool brokerPool, LocalCollection collection) {
        this.user = user;
        this.brokerPool = brokerPool;
        this.collection = collection;
    }

    protected XmldbURI resolve(XmldbURI name) {
        if (this.collection != null) {
            return this.collection.getPathURI().resolveCollectionPath(name);
        }
        return name;
    }

    protected <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> read(XmldbURI collectionUri) throws XMLDBException {
        return readOp -> this.withDb((broker, transaction) -> this.read(broker, transaction, collectionUri).apply(readOp));
    }

    protected <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> read(XmldbURI collectionUri, int errorCode) throws XMLDBException {
        return readOp -> this.withDb((broker, transaction) -> this.read(broker, transaction, collectionUri, errorCode).apply(readOp));
    }

    protected <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> read(DBBroker broker, Txn transaction, XmldbURI collectionUri) throws XMLDBException {
        return this.with(Lock.LockMode.READ_LOCK, broker, transaction, collectionUri);
    }

    protected <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> read(DBBroker broker, Txn transaction, XmldbURI collectionUri, int errorCode) throws XMLDBException {
        return this.with(Lock.LockMode.READ_LOCK, broker, transaction, collectionUri, errorCode);
    }

    protected <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> modify(XmldbURI collectionUri) throws XMLDBException {
        return modifyOp -> this.withDb((broker, transaction) -> this.modify(broker, transaction, collectionUri).apply(modifyOp));
    }

    protected <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> modify(DBBroker broker, Txn transaction, XmldbURI collectionUri) throws XMLDBException {
        return this.with(Lock.LockMode.WRITE_LOCK, broker, transaction, collectionUri);
    }

    protected <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> with(Lock.LockMode lockMode, DBBroker broker, Txn transaction, XmldbURI collectionUri) throws XMLDBException {
        return this.with(lockMode, broker, transaction, collectionUri, 201);
    }

    protected <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> with(Lock.LockMode lockMode, DBBroker broker, Txn transaction, XmldbURI collectionUri, int errorCode) throws XMLDBException {
        return collectionOp -> {
            Collection coll = null;
            try {
                Object result;
                coll = broker.openCollection(collectionUri, lockMode);
                if (coll == null) {
                    throw new XMLDBException(errorCode, "Collection " + collectionUri.toString() + " not found");
                }
                Object r = result = collectionOp.apply(coll, broker, transaction);
                return r;
            }
            catch (PermissionDeniedException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            finally {
                if (coll != null) {
                    coll.release(lockMode);
                }
            }
        };
    }

    /*
     * Exception decompiling
     */
    <R> R withDb(LocalXmldbFunction<R> dbOperation) throws XMLDBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

