/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.annotation.Nullable;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.security.Permission;
import org.exist.util.EXistInputSource;
import org.exist.util.VirtualTempFile;
import org.exist.xmldb.AbstractRemote;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.ExtendedResource;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.InputSource;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public abstract class AbstractRemoteResource
extends AbstractRemote
implements EXistResource,
ExtendedResource,
Resource {
    protected final XmldbURI path;
    private String mimeType;
    protected VirtualTempFile vfile = null;
    private VirtualTempFile contentVFile = null;
    protected InputSource inputSource = null;
    private boolean isLocal = false;
    private long contentLen = 0L;
    private Permission permissions = null;
    Date dateCreated = null;
    Date dateModified = null;

    protected AbstractRemoteResource(RemoteCollection parent, XmldbURI documentName, String mimeType) throws XMLDBException {
        super(parent);
        this.path = documentName.numSegments() > 1 ? documentName : parent.getPathURI().append(documentName);
        this.mimeType = mimeType;
    }

    @Override
    @Nullable
    public Properties getProperties() {
        return this.collection.getProperties();
    }

    public Object getContent() throws XMLDBException {
        Object res = this.getExtendedContent();
        if (this.isLocal) {
            return res;
        }
        if (res != null) {
            if (res instanceof Path) {
                return this.readFile((Path)res);
            }
            if (res instanceof File) {
                return this.readFile(((File)res).toPath());
            }
            if (res instanceof InputSource) {
                return this.readFile((InputSource)res);
            }
        }
        return res;
    }

    protected void finalize() throws Throwable {
        try {
            this.freeResources();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void freeResources() {
        this.vfile = null;
        this.inputSource = null;
        if (this.contentVFile != null) {
            this.contentVFile.delete();
            this.contentVFile = null;
        }
        this.isLocal = true;
    }

    @Deprecated
    protected byte[] getData() throws XMLDBException {
        Object res = this.getExtendedContent();
        if (res != null) {
            if (res instanceof Path) {
                return this.readFile((Path)res);
            }
            if (res instanceof File) {
                return this.readFile(((File)res).toPath());
            }
            if (res instanceof InputSource) {
                return this.readFile((InputSource)res);
            }
            if (res instanceof String) {
                return ((String)res).getBytes(StandardCharsets.UTF_8);
            }
        }
        return (byte[])res;
    }

    @Override
    public long getContentLength() throws XMLDBException {
        return this.contentLen;
    }

    @Override
    public Date getCreationTime() throws XMLDBException {
        return this.dateCreated;
    }

    @Override
    public Date getLastModificationTime() throws XMLDBException {
        return this.dateModified;
    }

    @Override
    public void setLastModificationTime(Date dateModified) throws XMLDBException {
        if (dateModified != null) {
            if (dateModified.before(this.getCreationTime())) {
                throw new XMLDBException(4, "Modification time must be after creation time.");
            }
            ArrayList<Object> params = new ArrayList<Object>(2);
            params.add(this.path.toString());
            params.add(dateModified.getTime());
            try {
                this.collection.getClient().execute("setLastModified", params);
            }
            catch (XmlRpcException e) {
                throw new XMLDBException(0, e.getMessage(), (Throwable)e);
            }
            this.dateModified = dateModified;
        }
    }

    public long getExtendedContentLength() throws XMLDBException {
        return this.contentLen;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public Collection getParentCollection() throws XMLDBException {
        return this.collection;
    }

    @Override
    public Permission getPermissions() {
        return this.permissions;
    }

    protected boolean setContentInternal(Object value) throws XMLDBException {
        this.freeResources();
        boolean wasSet = false;
        if (value instanceof VirtualTempFile) {
            this.vfile = (VirtualTempFile)value;
            try {
                this.vfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setExtendendContentLength(this.vfile.length());
            wasSet = true;
        } else if (value instanceof Path) {
            this.vfile = new VirtualTempFile(((Path)value).toFile());
            this.setExtendendContentLength(this.vfile.length());
            wasSet = true;
        } else if (value instanceof File) {
            this.vfile = new VirtualTempFile((File)value);
            this.setExtendendContentLength(this.vfile.length());
            wasSet = true;
        } else if (value instanceof InputSource) {
            this.inputSource = (InputSource)value;
            wasSet = true;
        } else if (value instanceof byte[]) {
            this.vfile = new VirtualTempFile((byte[])value);
            this.setExtendendContentLength(this.vfile.length());
            wasSet = true;
        } else if (value instanceof String) {
            this.vfile = new VirtualTempFile(((String)value).getBytes(StandardCharsets.UTF_8));
            this.setExtendendContentLength(this.vfile.length());
            wasSet = true;
        }
        return wasSet;
    }

    protected void setExtendendContentLength(long len) {
        this.contentLen = len;
    }

    public void setContentLength(int len) {
        this.contentLen = len;
    }

    public void setContentLength(long len) {
        this.contentLen = len;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setPermissions(Permission perms) {
        this.permissions = perms;
    }

    @Override
    public void getContentIntoAFile(Path localfile) throws XMLDBException {
        try (OutputStream os = Files.newOutputStream(localfile, new OpenOption[0]);){
            this.getContentIntoAStream(os);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    protected void getRemoteContentIntoLocalFile(OutputStream os, boolean isRetrieve, int handle, int pos) throws XMLDBException {
        String command;
        ArrayList<Object> params = new ArrayList<Object>();
        if (isRetrieve) {
            command = "retrieveFirstChunk";
            params.add(handle);
            params.add(pos);
        } else {
            command = "getDocumentData";
            params.add(this.path.toString());
        }
        params.add(this.getProperties());
        try {
            int decLength;
            String method;
            boolean useLongOffset;
            VirtualTempFile vtmpfile = new VirtualTempFile();
            vtmpfile.setTempPrefix("eXistARR");
            vtmpfile.setTempPostfix("XMLResource".equals(this.getResourceType()) ? ".xml" : ".bin");
            Map table = (Map)this.collection.getClient().execute(command, params);
            if (table.containsKey("supports-long-offset") && ((Boolean)table.get("supports-long-offset")).booleanValue()) {
                useLongOffset = true;
                method = "getNextExtendedChunk";
            } else {
                useLongOffset = false;
                method = "getNextChunk";
            }
            long offset = ((Integer)table.get("offset")).intValue();
            byte[] data = (byte[])table.get("data");
            boolean isCompressed = "yes".equals(this.getProperties().getProperty("compress-output", "no"));
            Inflater dec = null;
            byte[] decResult = null;
            if (isCompressed) {
                dec = new Inflater();
                decResult = new byte[65536];
                dec.setInput(data);
                do {
                    decLength = dec.inflate(decResult);
                    vtmpfile.write(decResult, 0, decLength);
                    if (os == null) continue;
                    os.write(decResult, 0, decLength);
                } while (decLength == decResult.length || !dec.needsInput());
            } else {
                vtmpfile.write(data);
                if (os != null) {
                    os.write(data);
                }
            }
            while (offset > 0L) {
                params.clear();
                params.add(table.get("handle"));
                params.add(useLongOffset ? Long.toString(offset) : Integer.valueOf((int)offset));
                table = (Map)this.collection.getClient().execute(method, params);
                offset = useLongOffset ? Long.parseLong((String)table.get("offset")) : (long)((Integer)table.get("offset")).intValue();
                data = (byte[])table.get("data");
                if (isCompressed) {
                    dec.setInput(data);
                    do {
                        decLength = dec.inflate(decResult);
                        vtmpfile.write(decResult, 0, decLength);
                        if (os == null) continue;
                        os.write(decResult, 0, decLength);
                    } while (decLength == decResult.length || !dec.needsInput());
                    continue;
                }
                vtmpfile.write(data);
                if (os == null) continue;
                os.write(data);
            }
            if (dec != null) {
                dec.end();
            }
            this.isLocal = false;
            this.contentVFile = vtmpfile;
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(301, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException | DataFormatException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.contentVFile != null) {
                try {
                    this.contentVFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected static InputStream getAnyStream(Object obj) throws XMLDBException {
        if (obj instanceof String) {
            return new ByteArrayInputStream(((String)obj).getBytes(StandardCharsets.UTF_8));
        }
        if (obj instanceof byte[]) {
            return new ByteArrayInputStream((byte[])obj);
        }
        throw new XMLDBException(1, "don't know how to handle value of type " + obj.getClass().getName());
    }

    protected void getContentIntoAStreamInternal(OutputStream os, Object obj, boolean isRetrieve, int handle, int pos) throws XMLDBException {
        if (this.vfile != null || this.contentVFile != null || this.inputSource != null || obj != null) {
            InputStream bis = null;
            try {
                bis = this.vfile != null ? this.vfile.getByteStream() : (this.inputSource != null ? this.inputSource.getByteStream() : (obj != null ? AbstractRemoteResource.getAnyStream(obj) : this.contentVFile.getByteStream()));
                this.copy(bis, os);
            }
            catch (IOException ioe) {
                throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
            }
            finally {
                if (this.inputSource != null) {
                    if (bis != null && bis.markSupported()) {
                        try {
                            bis.reset();
                        }
                        catch (IOException iOException) {}
                    }
                } else if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.getRemoteContentIntoLocalFile(os, isRetrieve, handle, pos);
    }

    protected Object getExtendedContentInternal(Object obj, boolean isRetrieve, int handle, int pos) throws XMLDBException {
        if (obj != null) {
            return obj;
        }
        if (this.vfile != null) {
            return this.vfile.getContent();
        }
        if (this.inputSource != null) {
            return this.inputSource;
        }
        if (this.contentVFile == null) {
            this.getRemoteContentIntoLocalFile(null, isRetrieve, handle, pos);
        }
        return this.contentVFile.getContent();
    }

    protected InputStream getStreamContentInternal(Object obj, boolean isRetrieve, int handle, int pos) throws XMLDBException {
        InputStream retval;
        try {
            if (this.vfile != null) {
                retval = this.vfile.getByteStream();
            } else if (this.inputSource != null) {
                retval = this.inputSource.getByteStream();
            } else if (obj != null) {
                retval = AbstractRemoteResource.getAnyStream(obj);
            } else {
                if (this.contentVFile == null) {
                    this.getRemoteContentIntoLocalFile(null, isRetrieve, handle, pos);
                }
                retval = this.contentVFile.getByteStream();
            }
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long getStreamLengthInternal(Object obj) throws XMLDBException {
        if (this.vfile != null) {
            return this.vfile.length();
        }
        if (this.inputSource != null && this.inputSource instanceof EXistInputSource) {
            return ((EXistInputSource)this.inputSource).getByteStreamLength();
        }
        if (obj != null) {
            if (obj instanceof String) {
                return ((String)obj).getBytes(StandardCharsets.UTF_8).length;
            }
            if (!(obj instanceof byte[])) throw new XMLDBException(1, "don't know how to handle value of type " + obj.getClass().getName());
            return ((byte[])obj).length;
        }
        if (this.contentVFile != null) {
            return this.contentVFile.length();
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.path.toString());
        params.add(this.getProperties());
        try {
            Map table = (Map)this.collection.getClient().execute("describeResource", params);
            if (!table.containsKey("content-length-64bit")) return ((Integer)table.get("content-length")).intValue();
            Object o = table.get("content-length-64bit");
            if (!(o instanceof Long)) return Long.parseLong((String)o);
            return (Long)o;
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(301, xre.getMessage(), (Throwable)xre);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] readFile(Path file) throws XMLDBException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Files.copy(file, (OutputStream)os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readFile(InputSource in) throws XMLDBException {
        InputStream bis = in.getByteStream();
        try {
            byte[] byArray = this.readFile(bis);
            return byArray;
        }
        finally {
            if (bis.markSupported()) {
                try {
                    bis.reset();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readFile(InputStream is) throws XMLDBException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            this.copy(is, (OutputStream)bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        int read;
        byte[] buffer = new byte[65536];
        while ((read = is.read(buffer)) > -1) {
            os.write(buffer, 0, read);
        }
    }

    @Override
    public void close() throws IOException {
        this.freeResources();
    }
}

