/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.exist.EXistException;
import org.exist.security.AuthenticationException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.util.SSLHelper;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.ShutdownListener;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class DatabaseImpl
implements Database {
    private static final Logger LOG = LogManager.getLogger(DatabaseImpl.class);
    protected static final String LOCAL_HOSTNAME = "";
    protected static final int UNKNOWN_CONNECTION = -1;
    protected static final int LOCAL_CONNECTION = 0;
    protected static final int REMOTE_CONNECTION = 1;
    public static final String CONF_XML = "conf.xml";
    private boolean autoCreate = false;
    private String configuration = null;
    private String currentInstanceName = null;
    private final Map<String, XmlRpcClient> rpcClients = new HashMap<String, XmlRpcClient>();
    private ShutdownListener shutdown = null;
    private int mode = -1;
    private Boolean ssl_enable = false;
    private Boolean ssl_allow_self_signed = true;
    private Boolean ssl_verify_hostname = false;
    public static final String CREATE_DATABASE = "create-database";
    public static final String DATABASE_ID = "database-id";
    public static final String CONFIGURATION = "configuration";
    public static final String SSL_ENABLE = "ssl-enable";
    public static final String SSL_ALLOW_SELF_SIGNED = "ssl-allow-self-signed";
    public static final String SSL_VERIFY_HOSTNAME = "ssl-verify-hostname";

    public DatabaseImpl() {
        String initdb = System.getProperty("exist.initdb");
        if (initdb != null) {
            this.autoCreate = initdb.equalsIgnoreCase("true");
        }
    }

    private void configure(String instanceName) throws XMLDBException {
        try {
            Configuration config = new Configuration(this.configuration, Optional.empty());
            BrokerPool.configure(instanceName, 1, 5, config);
            if (this.shutdown != null) {
                BrokerPool.getInstance(instanceName).registerShutdownListener(this.shutdown);
            }
            this.currentInstanceName = instanceName;
        }
        catch (Exception e) {
            throw new XMLDBException(1, "configuration error: " + e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public boolean acceptsURI(String uri) throws XMLDBException {
        try {
            String newURIString = XmldbURI.recoverPseudoURIs(uri);
            XmldbURI xmldbURI = XmldbURI.xmldbUriFor("xmldb:" + newURIString);
            return this.acceptsURI(xmldbURI);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(401, "xmldb URI is not well formed: xmldb:" + uri);
        }
    }

    public boolean acceptsURI(XmldbURI xmldbURI) throws XMLDBException {
        return true;
    }

    @Deprecated
    public Collection getCollection(String uri, String user, String password) throws XMLDBException {
        try {
            String newURIString = XmldbURI.recoverPseudoURIs(uri);
            XmldbURI xmldbURI = XmldbURI.xmldbUriFor("xmldb:" + newURIString);
            return this.getCollection(xmldbURI, user, password);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(401, "xmldb URI is not well formed: xmldb:" + uri);
        }
    }

    public Collection getCollection(XmldbURI xmldbURI, String user, String password) throws XMLDBException {
        if ("local".equals(xmldbURI.getApiName())) {
            return this.getLocalCollection(xmldbURI, user, password);
        }
        if ("xmlrpc".equals(xmldbURI.getApiName())) {
            return this.getRemoteCollection(xmldbURI, user, password);
        }
        throw new XMLDBException(401, "Unknown or unparsable API for: " + xmldbURI);
    }

    private Collection getLocalCollection(XmldbURI xmldbURI, String user, String password) throws XMLDBException {
        this.mode = 0;
        if (!BrokerPool.isConfigured(xmldbURI.getInstanceName())) {
            if (this.autoCreate) {
                this.configure(xmldbURI.getInstanceName());
            } else {
                throw new XMLDBException(202, "Local database server is not running");
            }
        }
        try {
            BrokerPool pool = BrokerPool.getInstance(xmldbURI.getInstanceName());
            Subject u = this.getUser(user, password, pool);
            return new LocalCollection(u, pool, xmldbURI.toCollectionPathURI());
        }
        catch (EXistException e) {
            throw new XMLDBException(1, "Can not access to local database instance", (Throwable)e);
        }
        catch (XMLDBException e) {
            switch (e.errorCode) {
                case 200: 
                case 201: 
                case 300: 
                case 301: {
                    LOG.debug(e.getMessage());
                    return null;
                }
            }
            LOG.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private Collection getRemoteCollection(XmldbURI xmldbURI, String user, String password) throws XMLDBException {
        this.mode = 1;
        if (user == null) {
            user = "guest";
            password = "guest";
        }
        if (password == null) {
            password = LOCAL_HOSTNAME;
        }
        try {
            String protocol;
            String string = protocol = this.ssl_enable != false ? "https" : "http";
            if (this.ssl_enable.booleanValue()) {
                SSLHelper.initialize(this.ssl_allow_self_signed, this.ssl_verify_hostname);
            }
            URL url = new URL(protocol, xmldbURI.getHost(), xmldbURI.getPort(), xmldbURI.getContext());
            XmlRpcClient rpcClient = this.getRpcClient(user, password, url);
            return DatabaseImpl.readCollection(xmldbURI.getRawCollectionPath(), rpcClient);
        }
        catch (MalformedURLException e) {
            throw new XMLDBException(401, e.getMessage());
        }
        catch (XMLDBException e) {
            switch (e.errorCode) {
                case 200: 
                case 201: 
                case 300: 
                case 301: {
                    LOG.debug(e.getMessage());
                    return null;
                }
            }
            LOG.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Collection readCollection(String c, XmlRpcClient rpcClient) throws XMLDBException {
        XmldbURI path;
        try {
            path = XmldbURI.xmldbUriFor(c);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        XmldbURI[] components = path.getPathSegments();
        if (components.length == 0) {
            throw new XMLDBException(200, "Could not find collection: " + path.toString());
        }
        XmldbURI rootName = components[0];
        if (XmldbURI.RELATIVE_ROOT_COLLECTION_URI.equals(rootName)) {
            rootName = XmldbURI.ROOT_COLLECTION_URI;
        }
        RemoteCollection current = RemoteCollection.instance(rpcClient, rootName);
        for (int i = 1; i < components.length; ++i) {
            if ((current = current.getChildCollection(components[i])) != null) continue;
            throw new XMLDBException(200, "Could not find collection: " + c);
        }
        return current;
    }

    private Subject getUser(String user, String password, BrokerPool pool) throws XMLDBException {
        try {
            if (user == null) {
                user = "guest";
                password = "guest";
            }
            SecurityManager securityManager = pool.getSecurityManager();
            return securityManager.authenticate(user, password);
        }
        catch (AuthenticationException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
    }

    private XmlRpcClient getRpcClient(String user, String password, URL url) throws XMLDBException {
        String key = user + "@" + url.toString();
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setEnabledForExtensions(true);
        config.setContentLengthOptional(true);
        config.setGzipCompressing(true);
        config.setGzipRequesting(true);
        config.setServerURL(url);
        config.setBasicUserName(user);
        config.setBasicPassword(password);
        XmlRpcClient client = Optional.ofNullable(this.rpcClients.get(key)).orElseGet(() -> {
            XmlRpcClient newClient = new XmlRpcClient();
            this.rpcClients.put(key, newClient);
            return newClient;
        });
        client.setConfig((XmlRpcClientConfig)config);
        return client;
    }

    public void setDatabaseShutdownListener(ShutdownListener listener) throws XMLDBException {
        this.shutdown = listener;
    }

    public String getConformanceLevel() throws XMLDBException {
        return "0";
    }

    @Deprecated
    public String getName() throws XMLDBException {
        return this.currentInstanceName != null ? this.currentInstanceName : "exist";
    }

    public String[] getNames() throws XMLDBException {
        return new String[]{this.currentInstanceName != null ? this.currentInstanceName : "exist"};
    }

    public String getProperty(String property) throws XMLDBException {
        String value;
        switch (property) {
            case "create-database": {
                value = Boolean.valueOf(this.autoCreate).toString();
                break;
            }
            case "database-id": {
                value = this.currentInstanceName;
                break;
            }
            case "configuration": {
                value = this.configuration;
                break;
            }
            case "ssl-enable": {
                value = this.ssl_enable.toString();
                break;
            }
            case "ssl-allow-self-signed": {
                value = this.ssl_allow_self_signed.toString();
                break;
            }
            case "ssl-verify-hostname": {
                value = this.ssl_verify_hostname.toString();
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    public void setProperty(String property, String value) throws XMLDBException {
        switch (property) {
            case "create-database": {
                this.autoCreate = "true".equals(value);
                break;
            }
            case "database-id": {
                this.currentInstanceName = value;
                break;
            }
            case "configuration": {
                this.configuration = value;
                break;
            }
            case "ssl-enable": {
                this.ssl_enable = Boolean.valueOf(value);
                break;
            }
            case "ssl-allow-self-signed": {
                this.ssl_allow_self_signed = Boolean.valueOf(value);
                break;
            }
            case "ssl-verify-hostname": {
                this.ssl_verify_hostname = Boolean.valueOf(value);
            }
        }
    }
}

