/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import org.exist.storage.BrokerPool;
import org.exist.storage.IndexStats;
import org.exist.storage.report.Statistics;
import org.exist.util.Configuration;

public class DatabaseStatus {
    private final String id;
    private final String confPath;
    private final Path dataDir;
    private final int runningBrokers;
    private final int availableBrokers;
    private final int maxBrokers;
    private Map<String, IndexStats> indexStats = new TreeMap<String, IndexStats>();

    public DatabaseStatus(BrokerPool pool) {
        this.confPath = null;
        Configuration conf = pool.getConfiguration();
        this.id = pool.getId();
        this.dataDir = (Path)conf.getProperty("db-connection.data-dir");
        this.runningBrokers = pool.countActiveBrokers();
        this.availableBrokers = pool.available();
        this.maxBrokers = pool.getMax();
        Statistics.generateIndexStatistics(conf, this.indexStats);
    }

    public int getAvailableBrokers() {
        return this.availableBrokers;
    }

    public String getConfPath() {
        return this.confPath;
    }

    public Path getDataDir() {
        return this.dataDir;
    }

    public String getId() {
        return this.id;
    }

    public int getMaxBrokers() {
        return this.maxBrokers;
    }

    public int getRunningBrokers() {
        return this.runningBrokers;
    }

    public IndexStats getIndexStats(String dbName) {
        return this.indexStats.get(dbName);
    }
}

