/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.net.URI;
import java.net.URISyntaxException;
import org.exist.xmldb.XmldbURI;

public class FullXmldbURI
extends XmldbURI {
    private URI wrappedURI;
    private String context;
    private String apiName;

    protected FullXmldbURI(URI xmldbURI) throws URISyntaxException {
        this(xmldbURI, true);
    }

    protected FullXmldbURI(URI xmldbURI, boolean mustHaveXMLDB) throws URISyntaxException {
        super(xmldbURI, mustHaveXMLDB);
    }

    @Override
    protected void parseURI(URI xmldbURI, boolean hadXmldbPrefix) throws URISyntaxException {
        this.wrappedURI = xmldbURI;
        if (hadXmldbPrefix) {
            if (this.wrappedURI.getScheme() == null) {
                throw new URISyntaxException("xmldb:" + this.wrappedURI.toString(), "xmldb URI scheme has no instance name");
            }
            String userInfo = this.wrappedURI.getUserInfo();
            if (this.wrappedURI.getHost() == null && this.wrappedURI.getAuthority() != null && (userInfo = this.wrappedURI.getAuthority()).endsWith("@")) {
                userInfo = userInfo.substring(0, userInfo.length() - 1);
            }
            if (userInfo != null) {
                StringBuilder recomputed = new StringBuilder();
                recomputed.append(this.wrappedURI.getScheme());
                recomputed.append("://");
                recomputed.append(this.wrappedURI.getHost());
                if (this.wrappedURI.getPort() != -1) {
                    recomputed.append(":").append(this.wrappedURI.getPort());
                }
                recomputed.append(this.wrappedURI.getRawPath());
                this.wrappedURI = new URI(recomputed.toString());
            }
        }
        super.parseURI(xmldbURI, hadXmldbPrefix);
    }

    @Override
    protected void splitPath(String path) throws URISyntaxException {
        int index = -1;
        int lastIndex = -1;
        this.context = null;
        String pathForSuper = null;
        if (path != null) {
            String host = this.getHost();
            if (host == null || "embedded-eXist-server".equals(host)) {
                if (this.getPort() != -1) {
                    throw new URISyntaxException("xmldb:" + this.wrappedURI.toString(), "Local xmldb URI should not provide a port");
                }
                this.apiName = "local";
                this.context = null;
                pathForSuper = path;
            } else {
                index = path.lastIndexOf("/xmlrpc");
                if (index > lastIndex) {
                    this.apiName = "xmlrpc";
                    pathForSuper = path.substring(index + "/xmlrpc".length());
                    this.context = path.substring(0, index) + "/xmlrpc";
                    lastIndex = index;
                }
                if ((index = path.lastIndexOf("/webdav")) > lastIndex) {
                    this.apiName = "webdav";
                    pathForSuper = path.substring(index + "/webdav".length());
                    this.context = path.substring(0, index) + "/webdav";
                    lastIndex = index;
                }
                if (this.apiName == null) {
                    this.apiName = "rest-style";
                    pathForSuper = path;
                    this.context = null;
                }
            }
        }
        super.splitPath(pathForSuper);
    }

    @Override
    protected void recomputeURI() throws URISyntaxException {
        URI oldWrappedURI = this.wrappedURI;
        StringBuilder buf = new StringBuilder();
        if (this.getInstanceName() != null) {
            buf.append(this.getInstanceName()).append("://");
        }
        if (this.getHost() != null) {
            buf.append(this.getHost());
        }
        if (this.getPort() != -1) {
            buf.append(":").append(this.getPort());
        }
        if (this.context != null) {
            buf.append(this.context);
        }
        if (this.getRawCollectionPath() != null) {
            buf.append(this.getRawCollectionPath());
        }
        try {
            this.wrappedURI = new URI(buf.toString());
        }
        catch (URISyntaxException e) {
            this.wrappedURI = oldWrappedURI;
            throw e;
        }
    }

    private void setContext(String context) {
        String oldContext = this.context;
        try {
            if (context != null && context.endsWith("/") && this.getHost() != null) {
                context = context.substring(0, context.length() - 1);
            }
            this.context = "".equals(context) ? null : context;
            this.recomputeURI();
        }
        catch (URISyntaxException e) {
            this.context = oldContext;
            throw new IllegalArgumentException("Invalid URI: " + e.getMessage());
        }
    }

    @Override
    public URI getURI() {
        return this.wrappedURI;
    }

    @Override
    public URI getXmldbURI() {
        return URI.create("xmldb:" + this.wrappedURI.toString());
    }

    @Override
    public String getInstanceName() {
        return this.wrappedURI.getScheme();
    }

    @Override
    public String getApiName() {
        return this.apiName;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public boolean isAbsolute() {
        return this.wrappedURI.isAbsolute();
    }

    @Override
    public boolean isContextAbsolute() {
        String currentContext = this.getContext();
        if (currentContext == null) {
            return true;
        }
        return currentContext.startsWith("/");
    }

    @Override
    public XmldbURI normalizeContext() {
        String currentContext = this.getContext();
        if (currentContext == null) {
            return this;
        }
        URI uri = URI.create(currentContext);
        try {
            FullXmldbURI xmldbURI = new FullXmldbURI(this.getXmldbURI());
            xmldbURI.setContext(uri.normalize().getRawPath());
            return xmldbURI;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + e.getMessage());
        }
    }

    @Override
    public URI relativizeContext(URI uri) {
        URI contextURI;
        if (uri == null) {
            throw new NullPointerException("The provided URI is null");
        }
        String currentContext = this.getContext();
        if (currentContext == null) {
            throw new NullPointerException("The current context is null");
        }
        if (!currentContext.endsWith("/")) {
            LOG.info("Added a final '/' to '" + currentContext + "'");
            contextURI = URI.create(currentContext + "/");
        } else {
            contextURI = URI.create(currentContext);
        }
        return contextURI.relativize(uri);
    }

    @Override
    public URI resolveContext(String str) throws NullPointerException, IllegalArgumentException {
        if (str == null) {
            throw new NullPointerException("The provided URI is null");
        }
        String currentContext = this.getContext();
        if (currentContext == null) {
            throw new NullPointerException("The current context is null");
        }
        if (!currentContext.endsWith("/")) {
            LOG.info("Added a final '/' to '" + currentContext + "'");
            currentContext = currentContext + "/";
        }
        URI contextURI = URI.create(currentContext);
        return contextURI.resolve(str);
    }

    @Override
    public URI resolveContext(URI uri) throws NullPointerException {
        if (uri == null) {
            throw new NullPointerException("The provided URI is null");
        }
        String currentContext = this.getContext();
        if (currentContext == null) {
            throw new NullPointerException("The current context is null");
        }
        if (!currentContext.endsWith("/")) {
            LOG.info("Added a final '/' to '" + currentContext + "'");
            currentContext = currentContext + "/";
        }
        URI contextURI = URI.create(currentContext);
        return contextURI.resolve(uri);
    }

    @Override
    public String toString() {
        if (this.hadXmldbPrefix) {
            return "xmldb:" + this.wrappedURI.toString();
        }
        return this.wrappedURI.toString();
    }

    @Override
    public String getAuthority() {
        return this.wrappedURI.getAuthority();
    }

    @Override
    public String getFragment() {
        return this.wrappedURI.getFragment();
    }

    @Override
    public int getPort() {
        return this.wrappedURI.getPort();
    }

    @Override
    public String getQuery() {
        return this.wrappedURI.getQuery();
    }

    @Override
    public String getRawAuthority() {
        return this.wrappedURI.getRawAuthority();
    }

    @Override
    public String getHost() {
        return this.wrappedURI.getHost();
    }

    @Override
    public String getUserInfo() {
        return this.wrappedURI.getUserInfo();
    }

    @Override
    public String getRawFragment() {
        return this.wrappedURI.getRawFragment();
    }

    @Override
    public String getRawQuery() {
        return this.wrappedURI.getRawQuery();
    }

    @Override
    public String getRawUserInfo() {
        return this.wrappedURI.getRawUserInfo();
    }
}

