/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.net.URISyntaxException;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.sync.Sync;
import org.exist.util.Occurrences;
import org.exist.xmldb.AbstractLocalService;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.XMLDBException;

public class LocalIndexQueryService
extends AbstractLocalService
implements IndexQueryService {
    public LocalIndexQueryService(Subject user, BrokerPool pool, LocalCollection parent) {
        super(user, pool, parent);
    }

    public String getName() throws XMLDBException {
        return "IndexQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    @Override
    public void reindexCollection() throws XMLDBException {
        this.reindexCollection(this.collection.getURI().toCollectionPathURI());
    }

    @Override
    public void reindexCollection(String collectionPath) throws XMLDBException {
        try {
            this.reindexCollection(XmldbURI.xmldbUriFor(collectionPath));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public void reindexCollection(XmldbURI col) throws XMLDBException {
        XmldbURI collectionPath = this.resolve(col);
        this.withDb((broker, transaction) -> {
            broker.reindexCollection(collectionPath);
            broker.sync(Sync.MAJOR);
            return null;
        });
    }

    @Override
    public void reindexDocument(String name) throws XMLDBException {
        this.reindexDocument(this.collection.getURI().toCollectionPathURI(), name);
    }

    private void reindexDocument(XmldbURI col, String docName) throws XMLDBException {
        XmldbURI collectionPath = this.resolve(col);
        this.withDb((broker, transaction) -> {
            DocumentImpl doc = null;
            try {
                doc = broker.getXMLResource(collectionPath.append(docName), Lock.LockMode.READ_LOCK);
                broker.reindexXMLResource(transaction, doc, DBBroker.IndexMode.STORE);
                broker.sync(Sync.MAJOR);
                Object var5_5 = null;
                return var5_5;
            }
            finally {
                if (doc != null) {
                    doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                }
            }
        });
    }

    @Override
    public void configureCollection(String configData) throws XMLDBException {
        this.modify(this.collection.getPathURI()).apply((collection, broker, transaction) -> {
            CollectionConfigurationManager mgr = this.brokerPool.getConfigurationManager();
            try {
                mgr.addConfiguration(transaction, broker, collection, configData);
                return null;
            }
            catch (CollectionConfigurationException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
        });
    }

    @Override
    public Occurrences[] getIndexedElements(boolean inclusive) throws XMLDBException {
        return (Occurrences[])this.read(this.collection.getPathURI()).apply((collection, broker, transaction) -> broker.getElementIndex().scanIndexedElements(collection, inclusive));
    }

    public String getProperty(String name) throws XMLDBException {
        return null;
    }

    public void setProperty(String name, String value) throws XMLDBException {
    }
}

