/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import com.evolvedbinary.j8fu.Either;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.debuggee.Debuggee;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.source.DBSource;
import org.exist.source.FileSource;
import org.exist.source.Source;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockedDocumentMap;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.AbstractLocalService;
import org.exist.xmldb.EXistXPathQueryService;
import org.exist.xmldb.EXistXQueryService;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.LocalResourceSet;
import org.exist.xmldb.LocalXMLResource;
import org.exist.xmldb.XmldbURI;
import org.exist.xmldb.function.LocalXmldbFunction;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.Sequence;
import org.w3c.dom.Node;
import org.xmldb.api.base.CompiledExpression;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class LocalXPathQueryService
extends AbstractLocalService
implements EXistXPathQueryService,
EXistXQueryService {
    private static final Logger LOG = LogManager.getLogger(LocalXPathQueryService.class);
    private final TreeMap<String, String> namespaceDecls = new TreeMap();
    private final TreeMap<String, Object> variableDecls = new TreeMap();
    private boolean xpathCompatible = true;
    private String moduleLoadPath = null;
    private final Properties properties;
    private boolean lockDocuments = false;
    private LockedDocumentMap lockedDocuments = null;
    private DBBroker reservedBroker = null;

    public LocalXPathQueryService(Subject user, BrokerPool pool, LocalCollection collection) {
        super(user, pool, collection);
        this.properties = new Properties(collection.getProperties());
    }

    public String getName() throws XMLDBException {
        return "XPathQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void clearNamespaces() throws XMLDBException {
        this.namespaceDecls.clear();
    }

    @Override
    public String getNamespace(String prefix) throws XMLDBException {
        return this.namespaceDecls.get(prefix);
    }

    public String getProperty(String property) throws XMLDBException {
        return this.properties.getProperty(property);
    }

    @Override
    public ResourceSet query(String query) throws XMLDBException {
        return this.query(query, null);
    }

    @Override
    public ResourceSet query(XMLResource res, String query) throws XMLDBException {
        return this.query(res, query, null);
    }

    @Override
    public ResourceSet query(String query, String sortBy) throws XMLDBException {
        XmldbURI[] docs = new XmldbURI[]{XmldbURI.create(this.collection.getName())};
        return this.doQuery(query, docs, null, sortBy);
    }

    @Override
    public ResourceSet query(XMLResource res, String query, String sortBy) throws XMLDBException {
        Node n = ((LocalXMLResource)res).root;
        if (n != null && n instanceof NodeImpl) {
            XmldbURI[] docs = new XmldbURI[]{XmldbURI.create(res.getParentCollection().getName())};
            return this.doQuery(query, docs, (NodeImpl)n, sortBy);
        }
        NodeProxy node = ((LocalXMLResource)res).getNode();
        if (node == null) {
            XmldbURI[] docs = new XmldbURI[]{XmldbURI.create(res.getParentCollection().getName()).append(res.getDocumentId())};
            return this.doQuery(query, docs, null, sortBy);
        }
        ExtArrayNodeSet set = new ExtArrayNodeSet(1);
        set.add(node);
        XmldbURI[] docs = new XmldbURI[]{node.getOwnerDocument().getURI()};
        return this.doQuery(query, docs, set, sortBy);
    }

    private ResourceSet doQuery(String query, XmldbURI[] docs, Sequence contextSet, String sortExpr) throws XMLDBException {
        return this.withDb((broker, transaction) -> {
            Either<XPathException, CompiledExpression> maybeExpr = this.compileAndCheck(broker, transaction, query);
            if (maybeExpr.isLeft()) {
                XPathException e = (XPathException)maybeExpr.left().get();
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            return this.execute(broker, transaction, docs, contextSet, (CompiledExpression)maybeExpr.right().get(), sortExpr);
        });
    }

    @Override
    public ResourceSet execute(CompiledExpression expression) throws XMLDBException {
        return this.withDb((broker, transaction) -> this.execute(broker, transaction, null, null, expression, null));
    }

    @Override
    public ResourceSet execute(XMLResource res, CompiledExpression expression) throws XMLDBException {
        return this.withDb((broker, transaction) -> {
            NodeProxy node = ((LocalXMLResource)res).getNode();
            if (node == null) {
                XmldbURI[] docs = new XmldbURI[]{XmldbURI.create(res.getParentCollection().getName()).append(res.getDocumentId())};
                return this.execute(broker, transaction, docs, null, expression, null);
            }
            ExtArrayNodeSet set = new ExtArrayNodeSet(1);
            set.add(node);
            XmldbURI[] docs = new XmldbURI[]{node.getOwnerDocument().getURI()};
            return this.execute(broker, transaction, docs, set, expression, null);
        });
    }

    private ResourceSet execute(DBBroker broker, Txn transaction, XmldbURI[] docs, Sequence contextSet, CompiledExpression expression, String sortExpr) throws XMLDBException {
        long start = System.currentTimeMillis();
        CompiledXQuery expr = (CompiledXQuery)expression;
        Sequence result = null;
        XQueryContext context = expr.getContext();
        try {
            context.setStaticallyKnownDocuments(docs);
            if (this.lockedDocuments != null) {
                context.setProtectedDocs(this.lockedDocuments);
            }
            this.setupContext(null, context);
            XQuery xquery = this.brokerPool.getXQueryService();
            Sequence resSeq = result = xquery.execute(broker, expr, contextSet, this.properties);
            context.runCleanupTasks(o -> {
                if (resSeq != null && o instanceof BinaryValue) {
                    for (int i = 0; i < resSeq.getItemCount(); ++i) {
                        if (resSeq.itemAt(i) != o) continue;
                        return false;
                    }
                }
                return true;
            });
        }
        catch (Exception e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Sequence resSeq = result;
                context.runCleanupTasks(o -> {
                    if (resSeq != null && o instanceof BinaryValue) {
                        for (int i = 0; i < resSeq.getItemCount(); ++i) {
                            if (resSeq.itemAt(i) != o) continue;
                            return false;
                        }
                    }
                    return true;
                });
                throw throwable;
            }
        }
        LOG.debug("query took " + (System.currentTimeMillis() - start) + " ms.");
        if (result != null) {
            return new LocalResourceSet(this.user, this.brokerPool, this.collection, this.properties, result, sortExpr);
        }
        return null;
    }

    @Override
    public ResourceSet execute(Source source) throws XMLDBException {
        return this.execute((DBBroker broker, Txn transaction) -> source);
    }

    @Override
    public ResourceSet executeStoredQuery(String uri) throws XMLDBException {
        return this.execute((DBBroker broker, Txn transaction) -> {
            DocumentImpl resource = broker.getResource(new XmldbURI(uri), 5);
            if (resource == null) {
                throw new XMLDBException(5, "No stored XQuery exists at: " + uri);
            }
            return new DBSource(broker, (BinaryDocument)resource, false);
        });
    }

    private ResourceSet execute(LocalXmldbFunction<Source> sourceOp) throws XMLDBException {
        return this.withDb((broker, transaction) -> {
            long start = System.currentTimeMillis();
            Source source = (Source)sourceOp.apply(broker, transaction);
            XmldbURI[] docs = new XmldbURI[]{XmldbURI.create(this.collection.getName())};
            XQuery xquery = this.brokerPool.getXQueryService();
            XQueryPool pool = this.brokerPool.getXQueryPool();
            CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, source);
            XQueryContext context = compiled == null ? new XQueryContext(broker.getBrokerPool()) : compiled.getContext();
            context.setStaticallyKnownDocuments(docs);
            if (this.variableDecls.containsKey("DBGp:session")) {
                context.declareVariable(Debuggee.SESSION, this.variableDecls.get("DBGp:session"));
                this.variableDecls.remove("DBGp:session");
            }
            this.setupContext(source, context);
            if (compiled == null) {
                compiled = xquery.compile(broker, context, source);
            }
            try {
                Sequence result = xquery.execute(broker, compiled, null, this.properties);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("query took " + (System.currentTimeMillis() - start) + " ms.");
                }
                LocalResourceSet localResourceSet = result != null ? new LocalResourceSet(this.user, this.brokerPool, this.collection, this.properties, result, null) : null;
                return localResourceSet;
            }
            finally {
                compiled.getContext().runCleanupTasks();
                pool.returnCompiledXQuery(source, compiled);
            }
        });
    }

    @Override
    public CompiledExpression compile(String query) throws XMLDBException {
        return this.withDb((broker, transaction) -> {
            Either<XPathException, CompiledExpression> maybeExpr = this.compileAndCheck(broker, transaction, query);
            if (maybeExpr.isLeft()) {
                XPathException e = (XPathException)maybeExpr.left().get();
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            return (CompiledExpression)maybeExpr.right().get();
        });
    }

    @Override
    public CompiledExpression compileAndCheck(String query) throws XMLDBException, XPathException {
        Either result = this.withDb((broker, transaction) -> this.compileAndCheck(broker, transaction, query));
        if (result.isLeft()) {
            throw (XPathException)result.left().get();
        }
        return (CompiledExpression)result.right().get();
    }

    private Either<XPathException, CompiledExpression> compileAndCheck(DBBroker broker, Txn transaction, String query) throws XMLDBException {
        long start = System.currentTimeMillis();
        XQuery xquery = broker.getBrokerPool().getXQueryService();
        XQueryContext context = new XQueryContext(broker.getBrokerPool());
        try {
            this.setupContext(null, context);
            CompiledXQuery expr = xquery.compile(broker, context, query);
            if (LOG.isDebugEnabled()) {
                LOG.debug("compilation took " + (System.currentTimeMillis() - start));
            }
            return Either.Right((Object)expr);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (XPathException e) {
            return Either.Left((Object)e);
        }
    }

    public ResourceSet queryResource(String resource, String query) throws XMLDBException {
        LocalXMLResource res = (LocalXMLResource)this.collection.getResource(resource);
        if (res == null) {
            throw new XMLDBException(301, "resource '" + resource + "' not found");
        }
        XmldbURI[] docs = new XmldbURI[]{XmldbURI.create(res.getParentCollection().getName()).append(res.getDocumentId())};
        return this.doQuery(query, docs, null, null);
    }

    protected void setupContext(Source source, XQueryContext context) throws XMLDBException, XPathException {
        try {
            context.setBaseURI(new AnyURIValue(this.properties.getProperty("base-uri", this.collection.getPath())));
        }
        catch (XPathException e) {
            throw new XMLDBException(5, "Invalid base uri", (Throwable)e);
        }
        if (this.moduleLoadPath != null) {
            context.setModuleLoadPath(this.moduleLoadPath);
        } else if (source != null) {
            String modulePath = null;
            if (source instanceof DBSource) {
                modulePath = ((DBSource)source).getDocumentPath().removeLastSegment().toString();
            } else if (source instanceof FileSource) {
                modulePath = ((FileSource)source).getPath().getParent().toString();
            }
            if (modulePath != null) {
                context.setModuleLoadPath(modulePath);
            }
        }
        for (Map.Entry<String, String> entry : this.namespaceDecls.entrySet()) {
            context.declareNamespace(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.variableDecls.entrySet()) {
            context.declareVariable(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void beginProtected() throws XMLDBException {
        try {
            boolean deadlockCaught;
            do {
                this.reservedBroker = this.brokerPool.get(Optional.of(this.user));
                deadlockCaught = false;
                DocumentSet docs = null;
                try {
                    Collection coll = this.reservedBroker.getCollection(this.collection.getPathURI());
                    this.lockedDocuments = new LockedDocumentMap();
                    docs = new DefaultDocumentSet();
                    coll.allDocs(this.reservedBroker, (MutableDocumentSet)docs, true, this.lockedDocuments, Lock.LockMode.WRITE_LOCK);
                }
                catch (LockException e) {
                    LOG.debug("Deadlock detected. Starting over again. Docs: " + docs.getDocumentCount() + "; locked: " + this.lockedDocuments.size());
                    this.lockedDocuments.unlock();
                    this.reservedBroker.close();
                    deadlockCaught = true;
                }
                catch (PermissionDeniedException e) {
                    throw new XMLDBException(4, "Permission denied on document");
                }
            } while (deadlockCaught);
        }
        catch (EXistException e) {
            if (this.reservedBroker != null) {
                this.reservedBroker.close();
            }
            throw new XMLDBException(1, e.getMessage());
        }
    }

    @Override
    public void endProtected() {
        this.lockDocuments = false;
        if (this.lockedDocuments != null) {
            this.lockedDocuments.unlock();
        }
        this.lockedDocuments = null;
        if (this.reservedBroker != null) {
            this.reservedBroker.close();
        }
        this.reservedBroker = null;
    }

    @Override
    public void removeNamespace(String ns) throws XMLDBException {
        Iterator<String> i = this.namespaceDecls.values().iterator();
        while (i.hasNext()) {
            if (!i.next().equals(ns)) continue;
            i.remove();
        }
    }

    @Override
    public void setCollection(org.xmldb.api.base.Collection col) throws XMLDBException {
    }

    @Override
    public void setNamespace(String prefix, String namespace) throws XMLDBException {
        this.namespaceDecls.put(prefix, namespace);
    }

    public void setProperty(String property, String value) throws XMLDBException {
        this.properties.setProperty(property, value);
    }

    @Override
    public void declareVariable(String qname, Object initialValue) throws XMLDBException {
        this.variableDecls.put(qname, initialValue);
    }

    @Override
    public void clearVariables() throws XMLDBException {
        this.variableDecls.clear();
    }

    @Override
    public void setXPathCompatibility(boolean backwardsCompatible) {
        this.xpathCompatible = backwardsCompatible;
    }

    @Override
    public void setModuleLoadPath(String path) {
        this.moduleLoadPath = path;
    }

    @Override
    public void dump(CompiledExpression expression, Writer writer) throws XMLDBException {
        CompiledXQuery expr = (CompiledXQuery)expression;
        expr.dump(writer);
    }
}

