/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.StringReader;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.util.LockException;
import org.exist.xmldb.AbstractLocalService;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.exist.xupdate.Modification;
import org.exist.xupdate.XUpdateProcessor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XUpdateQueryService;

public class LocalXUpdateQueryService
extends AbstractLocalService
implements XUpdateQueryService {
    private static final Logger LOG = LogManager.getLogger(LocalXUpdateQueryService.class);
    private XUpdateProcessor processor = null;

    public LocalXUpdateQueryService(Subject user, BrokerPool pool, LocalCollection parent) {
        super(user, pool, parent);
    }

    public String getName() throws XMLDBException {
        return "XUpdateQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public long updateResource(String id, String commands) throws XMLDBException {
        return this.withDb((broker, transaction) -> {
            long start = System.currentTimeMillis();
            MutableDocumentSet docs = (MutableDocumentSet)this.read(broker, transaction, this.collection.getPathURI()).apply((collection, broker1, transaction1) -> {
                MutableDocumentSet d = new DefaultDocumentSet();
                if (id == null) {
                    d = collection.allDocs(broker1, d, true);
                } else {
                    try {
                        XmldbURI resourceURI = XmldbURI.xmldbUriFor(id);
                        DocumentImpl doc = collection.getDocument(broker1, resourceURI);
                        if (doc == null) {
                            throw new XMLDBException(301, "Resource not found: " + id);
                        }
                        d.add(doc);
                    }
                    catch (URISyntaxException e) {
                        throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                    }
                }
                return d;
            });
            try {
                if (this.processor == null) {
                    this.processor = new XUpdateProcessor(broker, docs);
                } else {
                    this.processor.setBroker(broker);
                    this.processor.setDocumentSet(docs);
                }
                Modification[] modifications = this.processor.parse(new InputSource(new StringReader(commands)));
                long mods = 0L;
                for (int i = 0; i < modifications.length; ++i) {
                    mods += modifications[i].process(transaction);
                    broker.flush();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("xupdate took " + (System.currentTimeMillis() - start) + "ms.");
                }
                Long l = mods;
                return l;
            }
            catch (ParserConfigurationException | LockException | SAXException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.processor != null) {
                    this.processor.reset();
                }
            }
        });
    }

    public long update(String commands) throws XMLDBException {
        return this.updateResource(null, commands);
    }

    public String getProperty(String name) throws XMLDBException {
        return null;
    }

    public void setProperty(String name, String value) throws XMLDBException {
    }
}

