/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.internal.aider.ACEAider;
import org.exist.util.Compressor;
import org.exist.util.EXistInputSource;
import org.exist.xmldb.AbstractRemote;
import org.exist.xmldb.AbstractRemoteResource;
import org.exist.xmldb.EXistCollection;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.ExtendedResource;
import org.exist.xmldb.RemoteBinaryResource;
import org.exist.xmldb.RemoteCollectionManagementService;
import org.exist.xmldb.RemoteDatabaseInstanceManager;
import org.exist.xmldb.RemoteIndexQueryService;
import org.exist.xmldb.RemoteUserManagementService;
import org.exist.xmldb.RemoteXMLResource;
import org.exist.xmldb.RemoteXPathQueryService;
import org.exist.xmldb.RemoteXUpdateQueryService;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.InputSource;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;

public class RemoteCollection
extends AbstractRemote
implements EXistCollection {
    protected static final Logger LOG = LogManager.getLogger(RemoteCollection.class);
    private static final int MAX_CHUNK_LENGTH = 524288;
    private static final int MAX_UPLOAD_CHUNK = 0xA00000;
    private final XmldbURI path;
    private final XmlRpcClient rpcClient;
    private Properties properties = null;

    public static RemoteCollection instance(XmlRpcClient xmlRpcClient, XmldbURI path) throws XMLDBException {
        return RemoteCollection.instance(xmlRpcClient, null, path);
    }

    public static RemoteCollection instance(XmlRpcClient xmlRpcClient, RemoteCollection parent, XmldbURI path) throws XMLDBException {
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(path.toString());
        try {
            boolean existsAndCanOpen = (Boolean)xmlRpcClient.execute("existsAndCanOpenCollection", params);
            if (existsAndCanOpen) {
                return new RemoteCollection(xmlRpcClient, parent, path);
            }
            return null;
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    private RemoteCollection(XmlRpcClient client, RemoteCollection parent, XmldbURI path) throws XMLDBException {
        super(parent);
        this.path = path.toCollectionPathURI();
        this.rpcClient = client;
    }

    protected XmlRpcClient getClient() {
        return this.rpcClient;
    }

    public void close() throws XMLDBException {
        try {
            this.rpcClient.execute("sync", Collections.EMPTY_LIST);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "failed to close collection", (Throwable)e);
        }
    }

    public String createId() throws XMLDBException {
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.getPath());
        try {
            return (String)this.rpcClient.execute("createResourceId", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "Failed to close collection", (Throwable)e);
        }
    }

    public Resource createResource(String id, String type) throws XMLDBException {
        try {
            XmldbURI newId;
            XmldbURI xmldbURI = newId = id == null ? XmldbURI.xmldbUriFor(this.createId()) : XmldbURI.xmldbUriFor(id);
            if ("XMLResource".equals(type)) {
                return new RemoteXMLResource(this, -1, -1, newId, Optional.empty());
            }
            if ("BinaryResource".equals(type)) {
                return new RemoteBinaryResource(this, newId);
            }
            throw new XMLDBException(302, "Unknown resource type: " + type);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public Collection getChildCollection(String name) throws XMLDBException {
        try {
            return this.getChildCollection(XmldbURI.xmldbUriFor(name));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public Collection getChildCollection(XmldbURI name) throws XMLDBException {
        return this.getChildCollection(name, true);
    }

    protected Collection getChildCollection(XmldbURI name, boolean refreshCacheIfNotFound) throws XMLDBException {
        return RemoteCollection.instance(this.rpcClient, this, name.numSegments() > 1 ? name : this.getPathURI().append(name));
    }

    public int getChildCollectionCount() throws XMLDBException {
        return this.listChildCollections().length;
    }

    public String getName() throws XMLDBException {
        return this.path.toString();
    }

    public Collection getParentCollection() throws XMLDBException {
        if (this.collection == null && !this.path.equals(XmldbURI.ROOT_COLLECTION_URI)) {
            XmldbURI parentUri = this.path.removeLastSegment();
            return new RemoteCollection(this.rpcClient, null, parentUri);
        }
        return this.collection;
    }

    public String getPath() throws XMLDBException {
        return this.getPathURI().toString();
    }

    @Override
    public XmldbURI getPathURI() {
        if (this.collection == null) {
            return XmldbURI.ROOT_COLLECTION_URI;
        }
        return this.path;
    }

    public String getProperty(String property) throws XMLDBException {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get(property);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public int getResourceCount() throws XMLDBException {
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(this.getPath());
        try {
            return (Integer)this.rpcClient.execute("getResourceCount", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "failed to close collection", (Throwable)e);
        }
    }

    public Service getService(String name, String version) throws XMLDBException {
        Object service;
        switch (name) {
            case "XPathQueryService": 
            case "XQueryService": {
                service = new RemoteXPathQueryService(this);
                break;
            }
            case "CollectionManagementService": 
            case "CollectionManager": {
                service = new RemoteCollectionManagementService(this, this.rpcClient);
                break;
            }
            case "UserManagementService": {
                service = new RemoteUserManagementService(this);
                break;
            }
            case "DatabaseInstanceManager": {
                service = new RemoteDatabaseInstanceManager(this.rpcClient);
                break;
            }
            case "IndexQueryService": {
                service = new RemoteIndexQueryService(this.rpcClient, this);
                break;
            }
            case "XUpdateQueryService": {
                service = new RemoteXUpdateQueryService(this);
                break;
            }
            default: {
                throw new XMLDBException(100);
            }
        }
        return service;
    }

    public Service[] getServices() throws XMLDBException {
        return new Service[]{new RemoteXPathQueryService(this), new RemoteCollectionManagementService(this, this.rpcClient), new RemoteUserManagementService(this), new RemoteDatabaseInstanceManager(this.rpcClient), new RemoteIndexQueryService(this.rpcClient, this), new RemoteXUpdateQueryService(this)};
    }

    protected boolean hasChildCollection(String name) throws XMLDBException {
        for (String child : this.listChildCollections()) {
            if (!child.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isOpen() throws XMLDBException {
        return true;
    }

    public String[] listChildCollections() throws XMLDBException {
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(this.getPath());
        try {
            Object[] r = (Object[])this.rpcClient.execute("getCollectionListing", params);
            String[] collections = new String[r.length];
            System.arraycopy(r, 0, collections, 0, r.length);
            return collections;
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    @Override
    public String[] getChildCollections() throws XMLDBException {
        return this.listChildCollections();
    }

    public String[] listResources() throws XMLDBException {
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(this.getPath());
        try {
            Object[] r = (Object[])this.rpcClient.execute("getDocumentListing", params);
            String[] resources = new String[r.length];
            System.arraycopy(r, 0, resources, 0, r.length);
            return resources;
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    @Override
    public String[] getResources() throws XMLDBException {
        return this.listResources();
    }

    public Permission getSubCollectionPermissions(String name) throws PermissionDeniedException, XMLDBException {
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(this.getPath());
        params.add(name);
        try {
            Map result = (Map)this.rpcClient.execute("getSubCollectionPermissions", params);
            String owner = (String)result.get("owner");
            String group = (String)result.get("group");
            int mode = (Integer)result.get("permissions");
            Stream<ACEAider> aces = this.extractAces(result.get("acl"));
            return this.getPermission(owner, group, mode, aces);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    public Permission getSubResourcePermissions(String name) throws PermissionDeniedException, XMLDBException {
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(this.getPath());
        params.add(name);
        try {
            Map result = (Map)this.rpcClient.execute("getSubResourcePermissions", params);
            String owner = (String)result.get("owner");
            String group = (String)result.get("group");
            int mode = (Integer)result.get("permissions");
            Stream<ACEAider> aces = this.extractAces(result.get("acl"));
            return this.getPermission(owner, group, mode, aces);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    public Long getSubCollectionCreationTime(String name) throws XMLDBException {
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(this.getPath());
        params.add(name);
        try {
            return (Long)this.rpcClient.execute("getSubCollectionCreationTime", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    public Resource getResource(String name) throws XMLDBException {
        Permission perm;
        Map hash;
        XmldbURI docUri;
        ArrayList<String> params = new ArrayList<String>(1);
        try {
            docUri = XmldbURI.xmldbUriFor(name);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        params.add(this.getPathURI().append(docUri).toString());
        try {
            hash = (Map)this.rpcClient.execute("describeResource", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        String docName = (String)hash.get("name");
        if (docName == null) {
            return null;
        }
        try {
            docUri = XmldbURI.xmldbUriFor(docName).lastSegment();
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        String owner = (String)hash.get("owner");
        String group = (String)hash.get("group");
        int mode = (Integer)hash.get("permissions");
        Stream<ACEAider> aces = this.extractAces(hash.get("acl"));
        try {
            perm = this.getPermission(owner, group, mode, aces);
        }
        catch (PermissionDeniedException pde) {
            throw new XMLDBException(4, "Unable to retrieve permissions for resource '" + name + "': " + pde.getMessage(), (Throwable)pde);
        }
        String type = (String)hash.get("type");
        long contentLen = 0L;
        if (hash.containsKey("content-length-64bit")) {
            Object o = hash.get("content-length-64bit");
            contentLen = o instanceof Long ? (Long)o : Long.parseLong((String)o);
        } else if (hash.containsKey("content-length")) {
            contentLen = ((Integer)hash.get("content-length")).intValue();
        }
        AbstractRemoteResource r = type == null || "XMLResource".equals(type) ? new RemoteXMLResource(this, -1, -1, docUri, Optional.empty()) : new RemoteBinaryResource(this, docUri);
        r.setPermissions(perm);
        r.setContentLength(contentLen);
        r.dateCreated = (Date)hash.get("created");
        r.dateModified = (Date)hash.get("modified");
        if (hash.containsKey("mime-type")) {
            r.setMimeType((String)hash.get("mime-type"));
        }
        return r;
    }

    public void registerService(Service serv) throws XMLDBException {
        throw new XMLDBException(2);
    }

    public void removeResource(Resource res) throws XMLDBException {
        ArrayList<String> params = new ArrayList<String>(1);
        try {
            params.add(this.getPathURI().append(XmldbURI.xmldbUriFor(res.getId())).toString());
            this.rpcClient.execute("remove", params);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(301, xre.getMessage(), (Throwable)xre);
        }
    }

    @Override
    public Date getCreationTime() throws XMLDBException {
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(this.getPath());
        try {
            return (Date)this.rpcClient.execute("getCreationDate", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
    }

    public void setProperty(String property, String value) throws XMLDBException {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(property, value);
    }

    public void storeResource(Resource res) throws XMLDBException {
        this.storeResource(res, null, null);
    }

    @Override
    public void storeResource(Resource res, Date a, Date b) throws XMLDBException {
        Object content;
        Object object = content = res instanceof ExtendedResource ? ((ExtendedResource)res).getExtendedContent() : res.getContent();
        if (content instanceof File || content instanceof InputSource) {
            long fileLength = -1L;
            if (content instanceof File) {
                File file = (File)content;
                if (!file.canRead()) {
                    throw new XMLDBException(301, "Failed to read resource from file " + file.getAbsolutePath());
                }
                fileLength = file.length();
            } else if (content instanceof EXistInputSource) {
                fileLength = ((EXistInputSource)content).getByteStreamLength();
            }
            if (res instanceof AbstractRemoteResource) {
                ((AbstractRemoteResource)res).dateCreated = a;
                ((AbstractRemoteResource)res).dateModified = b;
            }
            if (!"BinaryResource".equals(res.getResourceType()) && fileLength != -1L && fileLength < 524288L) {
                this.store((RemoteXMLResource)res);
            } else {
                this.uploadAndStore(res);
            }
        } else {
            ((AbstractRemoteResource)res).dateCreated = a;
            ((AbstractRemoteResource)res).dateModified = b;
            if ("XMLResource".equals(res.getResourceType())) {
                this.store((RemoteXMLResource)res);
            } else {
                this.store((RemoteBinaryResource)res);
            }
        }
    }

    private void store(RemoteXMLResource res) throws XMLDBException {
        byte[] data = res.getData();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(data);
        try {
            params.add(this.getPathURI().append(XmldbURI.xmldbUriFor(res.getId())).toString());
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        params.add(1);
        if (res.getCreationTime() != null) {
            params.add(res.getCreationTime());
            params.add(res.getLastModificationTime());
        }
        try {
            this.rpcClient.execute("parse", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(301, xre == null ? "Unknown error" : xre.getMessage(), (Throwable)xre);
        }
    }

    private void store(RemoteBinaryResource res) throws XMLDBException {
        byte[] data = (byte[])res.getContent();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(data);
        try {
            params.add(this.getPathURI().append(XmldbURI.xmldbUriFor(res.getId())).toString());
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        params.add(res.getMimeType());
        params.add(Boolean.TRUE);
        if (res.getCreationTime() != null) {
            params.add(res.getCreationTime());
            params.add(res.getLastModificationTime());
        }
        try {
            this.rpcClient.execute("storeBinary", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(0, xre == null ? "unknown error" : xre.getMessage(), (Throwable)xre);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadAndStore(Resource res) throws XMLDBException {
        block29: {
            InputStream is = null;
            String descString = "<unknown>";
            try {
                if (res instanceof RemoteBinaryResource) {
                    is = ((RemoteBinaryResource)res).getStreamContent();
                    descString = ((RemoteBinaryResource)res).getStreamSymbolicPath();
                } else {
                    Object content = res.getContent();
                    if (content instanceof File) {
                        File file = (File)content;
                        try {
                            is = new BufferedInputStream(new FileInputStream(file));
                        }
                        catch (FileNotFoundException e) {
                            throw new XMLDBException(301, "could not read resource from file " + file.getAbsolutePath(), (Throwable)e);
                        }
                    } else if (content instanceof InputSource) {
                        is = ((InputSource)content).getByteStream();
                        if (content instanceof EXistInputSource) {
                            descString = ((EXistInputSource)content).getSymbolicPath();
                        }
                    }
                }
                byte[] chunk = new byte[0xA00000];
                try {
                    ArrayList<Object> params;
                    byte[] compressed;
                    int len;
                    String fileName = null;
                    while ((len = is.read(chunk)) > -1) {
                        compressed = Compressor.compress(chunk, len);
                        params = new ArrayList();
                        if (fileName != null) {
                            params.add(fileName);
                        }
                        params.add(compressed);
                        params.add(len);
                        fileName = (String)this.rpcClient.execute("uploadCompressed", params);
                    }
                    if (fileName == null) {
                        compressed = Compressor.compress(new byte[0], 0);
                        params = new ArrayList();
                        params.add(compressed);
                        params.add(0);
                        fileName = (String)this.rpcClient.execute("uploadCompressed", params);
                    }
                    params = new ArrayList<Object>();
                    ArrayList<Object> paramsEx = new ArrayList<Object>();
                    params.add(fileName);
                    paramsEx.add(fileName);
                    try {
                        String resURI = this.getPathURI().append(XmldbURI.xmldbUriFor(res.getId())).toString();
                        params.add(resURI);
                        paramsEx.add(resURI);
                    }
                    catch (URISyntaxException e) {
                        throw new XMLDBException(5, (Throwable)e);
                    }
                    params.add(Boolean.TRUE);
                    paramsEx.add(Boolean.TRUE);
                    if (res instanceof EXistResource) {
                        EXistResource rxres = (EXistResource)res;
                        params.add(rxres.getMimeType());
                        paramsEx.add(rxres.getMimeType());
                        paramsEx.add("BinaryResource".equals(res.getResourceType()) ? Boolean.FALSE : Boolean.TRUE);
                        if (rxres.getCreationTime() != null) {
                            params.add(rxres.getCreationTime());
                            paramsEx.add(rxres.getCreationTime());
                            params.add(rxres.getLastModificationTime());
                            paramsEx.add(rxres.getLastModificationTime());
                        }
                    }
                    try {
                        this.rpcClient.execute("parseLocalExt", paramsEx);
                    }
                    catch (XmlRpcException e) {
                        String excMsg = e.getMessage();
                        if (excMsg.contains("No such handler") || excMsg.contains("No method matching")) {
                            this.rpcClient.execute("parseLocal", params);
                            break block29;
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    throw new XMLDBException(301, "failed to read resource from " + descString, (Throwable)e);
                }
                catch (XmlRpcException e) {
                    throw new XMLDBException(1, "networking error", (Throwable)e);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn(ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
        }
    }

    @Override
    public boolean isRemoteCollection() throws XMLDBException {
        return true;
    }

    @Override
    public void setTriggersEnabled(boolean triggersEnabled) throws XMLDBException {
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.getPath());
        params.add(Boolean.toString(triggersEnabled));
        try {
            this.rpcClient.execute("setTriggersEnabled", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, "networking error", (Throwable)e);
        }
    }
}

