/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.exist.dom.QName;
import org.exist.util.Occurrences;
import org.exist.xmldb.AbstractRemote;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class RemoteIndexQueryService
extends AbstractRemote
implements IndexQueryService {
    private final XmlRpcClient client;

    public RemoteIndexQueryService(XmlRpcClient client, RemoteCollection parent) {
        super(parent);
        this.client = client;
    }

    public String getName() throws XMLDBException {
        return "IndexQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    @Override
    public void reindexCollection() throws XMLDBException {
        this.reindexCollection(this.collection.getPath());
    }

    @Override
    @Deprecated
    public void reindexCollection(String collectionPath) throws XMLDBException {
        try {
            this.reindexCollection(XmldbURI.xmldbUriFor(collectionPath));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public void reindexCollection(XmldbURI collection) throws XMLDBException {
        XmldbURI collectionPath = this.resolve(collection);
        ArrayList<String> params = new ArrayList<String>();
        params.add(collectionPath.toString());
        try {
            this.client.execute("reindexCollection", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while doing reindexCollection: ", (Throwable)e);
        }
    }

    @Override
    public void reindexDocument(String name) throws XMLDBException {
        XmldbURI collectionPath = this.resolve(this.collection.getPathURI());
        XmldbURI documentPath = collectionPath.append(name);
        ArrayList<String> params = new ArrayList<String>();
        params.add(documentPath.toString());
        try {
            this.client.execute("reindexDocument", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while doing reindexDocument: ", (Throwable)e);
        }
    }

    @Override
    public Occurrences[] getIndexedElements(boolean inclusive) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(this.collection.getPath());
            params.add(inclusive);
            Object[] result = (Object[])this.client.execute("getIndexedElements", params);
            Stream<Occurrences> occurrences = Arrays.stream(result).map(o -> (Object[])o).map(row -> new Occurrences(new QName(row[0].toString(), row[1].toString(), row[2].toString()), (Integer)row[3]));
            return (Occurrences[])occurrences.toArray(Occurrences[]::new);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while retrieving indexed elements", (Throwable)e);
        }
    }

    public void setCollection(Collection collection) throws XMLDBException {
        this.collection = (RemoteCollection)collection;
    }

    public String getProperty(String name) throws XMLDBException {
        return null;
    }

    public void setProperty(String name, String value) throws XMLDBException {
    }

    @Override
    public void configureCollection(String configData) throws XMLDBException {
        String path = this.collection.getPath();
        ArrayList<String> params = new ArrayList<String>();
        params.add(path);
        params.add(configData);
        try {
            this.client.execute("configureCollection", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while doing reindexCollection: ", (Throwable)e);
        }
    }
}

