/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.RemoteXMLResource;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.XMLDBException;

public class RemoteResourceIterator
implements ResourceIterator {
    private final RemoteCollection collection;
    private final List<Object> resources;
    private final int indentXML;
    private final String encoding;
    private int pos = 0;

    public RemoteResourceIterator(RemoteCollection collection, List<Object> resources, int indentXML, String encoding) {
        this.collection = collection;
        this.resources = resources;
        this.indentXML = indentXML;
        this.encoding = encoding;
    }

    public int getLength() {
        return this.resources.size();
    }

    public boolean hasMoreResources() throws XMLDBException {
        return this.pos < this.resources.size();
    }

    public void setNext(int next) {
        this.pos = next;
    }

    public Resource nextResource() throws XMLDBException {
        if (this.pos >= this.resources.size()) {
            return null;
        }
        if (this.resources.get(this.pos) instanceof List) {
            List v = (List)this.resources.get(this.pos++);
            String doc = (String)v.get(0);
            String s_id = (String)v.get(1);
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(doc);
            params.add(s_id);
            params.add(this.indentXML);
            params.add(this.encoding);
            try {
                byte[] data = (byte[])this.collection.getClient().execute("retrieve", params);
                RemoteXMLResource res = new RemoteXMLResource(this.collection, XmldbURI.xmldbUriFor(doc), Optional.of(doc + "_" + s_id));
                res.setContent(new String(data, this.encoding));
                return res;
            }
            catch (XmlRpcException xre) {
                throw new XMLDBException(301, xre.getMessage(), (Throwable)xre);
            }
            catch (IOException ioe) {
                throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
            }
            catch (URISyntaxException e) {
                throw new XMLDBException(5, e.getMessage(), (Throwable)e);
            }
        }
        RemoteXMLResource res = new RemoteXMLResource(this.collection, null, Optional.of(Integer.toString(this.pos)));
        res.setContent(this.resources.get(this.pos++));
        return res;
    }
}

