/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import com.evolvedbinary.j8fu.function.FunctionE;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.util.VirtualTempFile;
import org.exist.xmldb.RemoteBinaryResource;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.RemoteXMLResource;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

public class RemoteResourceSet
implements ResourceSet {
    private final RemoteCollection collection;
    private int handle = -1;
    private int hash = -1;
    private final List resources;
    private final Properties outputProperties;
    private static Logger LOG = LogManager.getLogger((String)RemoteResourceSet.class.getName());

    public RemoteResourceSet(RemoteCollection col, Properties properties, Object[] resources, int handle, int hash) {
        this.handle = handle;
        this.hash = hash;
        this.resources = new ArrayList<Object>(Arrays.asList(resources));
        this.collection = col;
        this.outputProperties = properties;
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public void clear() throws XMLDBException {
        if (this.handle < 0) {
            return;
        }
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(this.handle);
        if (this.hash > -1) {
            params.add(this.hash);
        }
        try {
            this.collection.getClient().execute("releaseQueryResult", params);
        }
        catch (XmlRpcException e) {
            LOG.error("Failed to release query result on server: " + e.getMessage(), (Throwable)e);
        }
        this.hash = -1;
        this.resources.clear();
        this.handle = -1;
    }

    public ResourceIterator getIterator() throws XMLDBException {
        return new NewResourceIterator();
    }

    public ResourceIterator getIterator(long start) throws XMLDBException {
        return new NewResourceIterator(start);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resource getMembersAsResource() throws XMLDBException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.handle);
        params.add(this.outputProperties);
        try {
            VirtualTempFile vtmpfile = null;
            try {
                vtmpfile = new VirtualTempFile();
                vtmpfile.setTempPrefix("eXistRRS");
                vtmpfile.setTempPostfix(".xml");
                Map table = (Map)this.collection.getClient().execute("retrieveAllFirstChunk", params);
                long offset = ((Integer)table.get("offset")).intValue();
                byte[] data = (byte[])table.get("data");
                boolean isCompressed = "yes".equals(this.outputProperties.getProperty("compress-output", "no"));
                Inflater dec = null;
                byte[] decResult = null;
                int decLength = 0;
                if (isCompressed) {
                    dec = new Inflater();
                    decResult = new byte[65536];
                    dec.setInput(data);
                    do {
                        decLength = dec.inflate(decResult);
                        vtmpfile.write(decResult, 0, decLength);
                    } while (decLength == decResult.length || !dec.needsInput());
                } else {
                    vtmpfile.write(data);
                }
                while (offset > 0L) {
                    params.clear();
                    params.add(table.get("handle"));
                    params.add(Long.toString(offset));
                    table = (Map)this.collection.getClient().execute("getNextExtendedChunk", params);
                    offset = Long.parseLong((String)table.get("offset"));
                    data = (byte[])table.get("data");
                    if (isCompressed) {
                        dec.setInput(data);
                        do {
                            decLength = dec.inflate(decResult);
                            vtmpfile.write(decResult, 0, decLength);
                        } while (decLength == decResult.length || !dec.needsInput());
                        continue;
                    }
                    vtmpfile.write(data);
                }
                if (dec != null) {
                    dec.end();
                }
                RemoteXMLResource res = new RemoteXMLResource(this.collection, this.handle, 0, XmldbURI.EMPTY_URI, Optional.empty());
                res.setContent(vtmpfile);
                res.setProperties(this.outputProperties);
                RemoteXMLResource remoteXMLResource = res;
                return remoteXMLResource;
            }
            catch (XmlRpcException xre) {
                String content;
                byte[] data = (byte[])this.collection.getClient().execute("retrieveAll", params);
                try {
                    content = new String(data, this.outputProperties.getProperty("encoding", "UTF-8"));
                }
                catch (UnsupportedEncodingException ue) {
                    LOG.warn((Object)ue);
                    content = new String(data);
                }
                RemoteXMLResource res = new RemoteXMLResource(this.collection, this.handle, 0, XmldbURI.EMPTY_URI, Optional.empty());
                res.setContent(content);
                res.setProperties(this.outputProperties);
                RemoteXMLResource remoteXMLResource = res;
                return remoteXMLResource;
            }
            catch (IOException | DataFormatException ioe) {
                throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
            }
            finally {
                if (vtmpfile != null) {
                    try {
                        vtmpfile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(301, xre.getMessage(), (Throwable)xre);
        }
    }

    public Resource getResource(long pos) throws XMLDBException {
        if (pos >= (long)this.resources.size()) {
            return null;
        }
        if (this.resources.get((int)pos) instanceof Resource) {
            return (Resource)this.resources.get((int)pos);
        }
        Map item = (Map)this.resources.get((int)pos);
        switch ((String)item.get("type")) {
            case "node()": 
            case "document-node()": 
            case "element()": 
            case "attribute()": 
            case "text()": 
            case "processing-instruction()": 
            case "comment()": 
            case "namespace()": 
            case "cdata-section()": {
                return this.getResourceNode((int)pos, item);
            }
            case "xs:base64Binary": {
                return this.getResourceBinaryValue((int)pos, item, Base64::decodeBase64);
            }
            case "xs:hexBinary": {
                return this.getResourceBinaryValue((int)pos, item, Hex::decodeHex);
            }
        }
        return this.getResourceValue((int)pos, item);
    }

    private RemoteXMLResource getResourceNode(int pos, Map<String, String> nodeDetail) throws XMLDBException {
        XmldbURI docUri;
        String doc = nodeDetail.get("docUri");
        Optional<String> s_id = Optional.ofNullable(nodeDetail.get("nodeId"));
        try {
            docUri = XmldbURI.xmldbUriFor(doc);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, e.getMessage(), (Throwable)e);
        }
        RemoteCollection parent = docUri.startsWith(XmldbURI.DB) ? RemoteCollection.instance(this.collection.getClient(), docUri.removeLastSegment()) : this.collection;
        parent.setProperties(this.outputProperties);
        RemoteXMLResource res = new RemoteXMLResource(parent, this.handle, pos, docUri, s_id);
        res.setProperties(this.outputProperties);
        return res;
    }

    private RemoteXMLResource getResourceValue(int pos, Map<String, String> valueDetail) throws XMLDBException {
        RemoteXMLResource res = new RemoteXMLResource(this.collection, this.handle, pos, XmldbURI.create(Long.toString(pos)), Optional.empty());
        res.setContent(valueDetail.get("value"));
        res.setProperties(this.outputProperties);
        return res;
    }

    private <E extends Exception> RemoteBinaryResource getResourceBinaryValue(int pos, Map<String, String> valueDetail, FunctionE<String, byte[], E> binaryDecoder) throws XMLDBException {
        byte[] content;
        String type = valueDetail.get("type");
        try {
            content = (byte[])binaryDecoder.apply((Object)valueDetail.get("value"));
        }
        catch (Exception e) {
            throw new XMLDBException(0, (Throwable)e);
        }
        RemoteBinaryResource res = new RemoteBinaryResource(this.collection, XmldbURI.create(Integer.toString(pos)), type, content);
        res.setProperties(this.outputProperties);
        return res;
    }

    public long getSize() throws XMLDBException {
        return this.resources == null ? 0L : (long)this.resources.size();
    }

    public void removeResource(long pos) throws XMLDBException {
        this.resources.remove(pos);
    }

    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }

    class NewResourceIterator
    implements ResourceIterator {
        long pos = 0L;

        public NewResourceIterator() {
        }

        public NewResourceIterator(long start) {
            this.pos = start;
        }

        public boolean hasMoreResources() throws XMLDBException {
            return RemoteResourceSet.this.resources == null ? false : this.pos < (long)RemoteResourceSet.this.resources.size();
        }

        public Resource nextResource() throws XMLDBException {
            return RemoteResourceSet.this.getResource(this.pos++);
        }
    }
}

