/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.security.ACLPermission;
import org.exist.security.AXSchemaType;
import org.exist.security.Account;
import org.exist.security.EXistSchemaType;
import org.exist.security.Group;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SchemaType;
import org.exist.security.User;
import org.exist.security.internal.aider.ACEAider;
import org.exist.security.internal.aider.GroupAider;
import org.exist.security.internal.aider.UserAider;
import org.exist.xmldb.AbstractRemote;
import org.exist.xmldb.EXistUserManagementService;
import org.exist.xmldb.RemoteCollection;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class RemoteUserManagementService
extends AbstractRemote
implements EXistUserManagementService {
    public RemoteUserManagementService(RemoteCollection collection) {
        super(collection);
    }

    @Override
    public String getName() {
        return "UserManagementService";
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public void addAccount(Account user) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(user.getName());
            params.add(user.getPassword() == null ? "" : user.getPassword());
            params.add(user.getDigestPassword() == null ? "" : user.getDigestPassword());
            String[] gl = user.getGroups();
            params.add(gl);
            params.add(user.isEnabled());
            params.add(user.getUserMask());
            HashMap<String, String> metadata = new HashMap<String, String>();
            for (SchemaType key : user.getMetadataKeys()) {
                metadata.put(key.getNamespace(), user.getMetadataValue(key));
            }
            params.add(metadata);
            this.collection.getClient().execute("addAccount", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void addGroup(Group role) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(role.getName());
            HashMap<String, String> metadata = new HashMap<String, String>();
            for (SchemaType key : role.getMetadataKeys()) {
                metadata.put(key.getNamespace(), role.getMetadataValue(key));
            }
            params.add(metadata);
            this.collection.getClient().execute("addGroup", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setUserPrimaryGroup(String username, String groupName) throws XMLDBException {
        ArrayList<String> params = new ArrayList<String>();
        params.add(username);
        params.add(groupName);
        try {
            this.collection.getClient().execute("setUserPrimaryGroup", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    private List<ACEAider> getACEs(Permission perm) {
        ArrayList<ACEAider> aces = new ArrayList<ACEAider>();
        ACLPermission aclPermission = (ACLPermission)((Object)perm);
        for (int i = 0; i < aclPermission.getACECount(); ++i) {
            aces.add(new ACEAider(aclPermission.getACEAccessType(i), aclPermission.getACETarget(i), aclPermission.getACEWho(i), aclPermission.getACEMode(i)));
        }
        return aces;
    }

    @Override
    public void setPermissions(Resource res, Permission perm) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(path);
            params.add(perm.getOwner().getName());
            params.add(perm.getGroup().getName());
            params.add(perm.getMode());
            if (perm instanceof ACLPermission) {
                params.add(this.getACEs(perm));
            }
            this.collection.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setPermissions(Collection child, Permission perm) throws XMLDBException {
        String path = ((RemoteCollection)child).getPath();
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(path);
            params.add(perm.getOwner().getName());
            params.add(perm.getGroup().getName());
            params.add(perm.getMode());
            if (perm instanceof ACLPermission) {
                params.add(this.getACEs(perm));
            }
            this.collection.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setPermissions(Collection child, String owner, String group, int mode, List<ACEAider> aces) throws XMLDBException {
        String path = ((RemoteCollection)child).getPath();
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(path);
            params.add(owner);
            params.add(group);
            params.add(mode);
            if (aces != null) {
                params.add(aces);
            }
            this.collection.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setPermissions(Resource res, String owner, String group, int mode, List<ACEAider> aces) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(path);
            params.add(owner);
            params.add(group);
            params.add(mode);
            if (aces != null) {
                params.add(aces);
            }
            this.collection.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void chmod(Resource res, String mode) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(path);
            params.add(mode);
            this.collection.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void chmod(Resource res, int mode) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(path);
            params.add(mode);
            this.collection.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void chmod(String mode) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(this.collection.getPath());
            params.add(mode);
            this.collection.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void chmod(int mode) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(this.collection.getPath());
            params.add(mode);
            this.collection.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void lockResource(Resource res, Account u) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(path);
            params.add(u.getName());
            this.collection.getClient().execute("lockResource", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String hasUserLock(Resource res) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(path);
            String userName = (String)this.collection.getClient().execute("hasUserLock", params);
            return userName != null && userName.length() > 0 ? userName : null;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void unlockResource(Resource res) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(path);
            this.collection.getClient().execute("unlockResource", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void chgrp(String group) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(this.collection.getPath());
            params.add(group);
            this.collection.getClient().execute("chgrp", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void chown(Account u) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(this.collection.getPath());
            params.add(u.getName());
            this.collection.getClient().execute("chown", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void chown(Account u, String group) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(this.collection.getPath());
            params.add(u.getName());
            params.add(group);
            this.collection.getClient().execute("chown", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void chgrp(Resource res, String group) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(path);
            params.add(group);
            this.collection.getClient().execute("chgrp", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void chown(Resource res, Account u) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(path);
            params.add(u.getName());
            this.collection.getClient().execute("chown", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void chown(Resource res, Account u, String group) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(path);
            params.add(u.getName());
            params.add(group);
            this.collection.getClient().execute("chown", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Date getSubCollectionCreationTime(Collection cParent, String name) throws XMLDBException {
        Long creationTime;
        if (this.collection == null) {
            throw new XMLDBException(201, "collection is null");
        }
        try {
            creationTime = ((RemoteCollection)cParent).getSubCollectionCreationTime(name);
            if (creationTime == null) {
                ArrayList<String> params = new ArrayList<String>();
                params.add(((RemoteCollection)cParent).getPath());
                params.add(name);
                creationTime = (Long)this.collection.getClient().execute("getSubCollectionCreationTime", params);
            }
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        return new Date(creationTime);
    }

    @Override
    public Permission getSubCollectionPermissions(Collection cParent, String name) throws XMLDBException {
        Permission perm;
        if (this.collection == null) {
            throw new XMLDBException(201, "collection is null");
        }
        try {
            perm = ((RemoteCollection)cParent).getSubCollectionPermissions(name);
            if (perm == null) {
                ArrayList<String> params = new ArrayList<String>();
                params.add(((RemoteCollection)cParent).getPath());
                params.add(name);
                Map result = (Map)this.collection.getClient().execute("getSubCollectionPermissions", params);
                String owner = (String)result.get("owner");
                String group = (String)result.get("group");
                int mode = (Integer)result.get("permissions");
                Stream<ACEAider> aces = this.extractAces(result.get("acl"));
                perm = this.getPermission(owner, group, mode, aces);
            }
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedException pde) {
            throw new XMLDBException(4, pde.getMessage(), (Throwable)pde);
        }
        return perm;
    }

    @Override
    public Permission getSubResourcePermissions(Collection cParent, String name) throws XMLDBException {
        Permission perm;
        if (this.collection == null) {
            throw new XMLDBException(301, "collection is null");
        }
        try {
            perm = ((RemoteCollection)cParent).getSubCollectionPermissions(name);
            if (perm == null) {
                ArrayList<String> params = new ArrayList<String>();
                params.add(((RemoteCollection)cParent).getPath());
                params.add(name);
                Map result = (Map)this.collection.getClient().execute("getSubResourcePermissions", params);
                String owner = (String)result.get("owner");
                String group = (String)result.get("group");
                int mode = (Integer)result.get("permissions");
                Stream<ACEAider> aces = this.extractAces(result.get("acl"));
                perm = this.getPermission(owner, group, mode, aces);
            }
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedException pde) {
            throw new XMLDBException(4, pde.getMessage(), (Throwable)pde);
        }
        return perm;
    }

    @Override
    public Permission getPermissions(Collection coll) throws XMLDBException {
        if (coll == null) {
            throw new XMLDBException(201, "collection is null");
        }
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(((RemoteCollection)coll).getPath());
            Map result = (Map)this.collection.getClient().execute("getPermissions", params);
            String owner = (String)result.get("owner");
            String group = (String)result.get("group");
            int mode = (Integer)result.get("permissions");
            Stream<ACEAider> aces = this.extractAces(result.get("acl"));
            return this.getPermission(owner, group, mode, aces);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedException pde) {
            throw new XMLDBException(4, pde.getMessage(), (Throwable)pde);
        }
    }

    @Override
    public Permission getPermissions(Resource res) throws XMLDBException {
        if (res == null) {
            throw new XMLDBException(301, "resource is null");
        }
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(path);
            Map result = (Map)this.collection.getClient().execute("getPermissions", params);
            String owner = (String)result.get("owner");
            String group = (String)result.get("group");
            int mode = (Integer)result.get("permissions");
            Stream<ACEAider> aces = this.extractAces(result.get("acl"));
            return this.getPermission(owner, group, mode, aces);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedException pde) {
            throw new XMLDBException(4, pde.getMessage(), (Throwable)pde);
        }
    }

    @Override
    public Permission[] listResourcePermissions() throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(this.collection.getPath());
            Map result = (Map)this.collection.getClient().execute("listDocumentPermissions", params);
            Permission[] perm = new Permission[result.size()];
            String[] resources = this.collection.listResources();
            for (int i = 0; i < resources.length; ++i) {
                Object[] t = (Object[])result.get(resources[i]);
                String owner = (String)t[0];
                String group = (String)t[1];
                int mode = (Integer)t[2];
                Stream<ACEAider> aces = this.extractAces(t[3]);
                perm[i] = this.getPermission(owner, group, mode, aces);
            }
            return perm;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedException pde) {
            throw new XMLDBException(4, pde.getMessage(), (Throwable)pde);
        }
    }

    @Override
    public Permission[] listCollectionPermissions() throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(this.collection.getPath());
            Map result = (Map)this.collection.getClient().execute("listCollectionPermissions", params);
            Permission[] perm = new Permission[result.size()];
            String[] collections = this.collection.listChildCollections();
            for (int i = 0; i < collections.length; ++i) {
                Object[] t = (Object[])result.get(collections[i]);
                String owner = (String)t[0];
                String group = (String)t[1];
                int mode = (Integer)t[2];
                Stream<ACEAider> aces = this.extractAces(t[3]);
                perm[i] = this.getPermission(owner, group, mode, aces);
            }
            return perm;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedException pde) {
            throw new XMLDBException(4, pde.getMessage(), (Throwable)pde);
        }
    }

    @Override
    public String getProperty(String name) throws XMLDBException {
        return null;
    }

    @Override
    public Account getAccount(String name) throws XMLDBException {
        try {
            Object[] groups;
            UserAider u;
            ArrayList<String> params = new ArrayList<String>();
            params.add(name);
            Map tab = (Map)this.collection.getClient().execute("getAccount", params);
            if (tab == null || tab.isEmpty()) {
                return null;
            }
            if (tab.get("default-group-id") != null) {
                GroupAider defaultGroup = new GroupAider((Integer)tab.get("default-group-id"), (String)tab.get("default-group-realmId"), (String)tab.get("default-group-name"));
                u = new UserAider((String)tab.get("realmId"), (String)tab.get("name"), defaultGroup);
            } else {
                u = new UserAider((String)tab.get("realmId"), (String)tab.get("name"));
            }
            for (Object group : groups = (Object[])tab.get("groups")) {
                u.addGroup((String)group);
            }
            u.setEnabled(Boolean.valueOf((String)tab.get("enabled")));
            u.setUserMask((Integer)tab.get("umask"));
            Map metadata = (Map)tab.get("metadata");
            for (Map.Entry m : metadata.entrySet()) {
                if (AXSchemaType.valueOfNamespace((String)m.getKey()) != null) {
                    u.setMetadataValue(AXSchemaType.valueOfNamespace((String)m.getKey()), (String)m.getValue());
                    continue;
                }
                if (EXistSchemaType.valueOfNamespace((String)m.getKey()) == null) continue;
                u.setMetadataValue(EXistSchemaType.valueOfNamespace((String)m.getKey()), (String)m.getValue());
            }
            return u;
        }
        catch (XmlRpcException e) {
            return null;
        }
    }

    @Override
    public Account[] getAccounts() throws XMLDBException {
        try {
            Object[] users = (Object[])this.collection.getClient().execute("getAccounts", Collections.EMPTY_LIST);
            Account[] u = new UserAider[users.length];
            for (int i = 0; i < u.length; ++i) {
                Map tab = (Map)users[i];
                int uid = -1;
                try {
                    uid = (Integer)tab.get("uid");
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                u[i] = new UserAider(uid, (String)tab.get("realmId"), (String)tab.get("name"));
                Object[] groups = (Object[])tab.get("groups");
                for (int j = 0; j < groups.length; ++j) {
                    ((UserAider)u[i]).addGroup((String)groups[j]);
                }
                ((UserAider)u[i]).setEnabled(Boolean.valueOf((String)tab.get("enabled")));
                ((UserAider)u[i]).setUserMask((Integer)tab.get("umask"));
                Map metadata = (Map)tab.get("metadata");
                for (Map.Entry m : metadata.entrySet()) {
                    if (AXSchemaType.valueOfNamespace((String)m.getKey()) != null) {
                        ((UserAider)u[i]).setMetadataValue(AXSchemaType.valueOfNamespace((String)m.getKey()), (String)m.getValue());
                        continue;
                    }
                    if (EXistSchemaType.valueOfNamespace((String)m.getKey()) == null) continue;
                    ((UserAider)u[i]).setMetadataValue(EXistSchemaType.valueOfNamespace((String)m.getKey()), (String)m.getValue());
                }
            }
            return u;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Group getGroup(String name) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(name);
            Map tab = (Map)this.collection.getClient().execute("getGroup", params);
            if (tab != null && !tab.isEmpty()) {
                Object[] managers;
                GroupAider group = new GroupAider((Integer)tab.get("id"), (String)tab.get("realmId"), (String)tab.get("name"));
                for (Object manager : managers = (Object[])tab.get("managers")) {
                    group.addManager(this.getAccount((String)manager));
                }
                Map metadata = (Map)tab.get("metadata");
                for (Map.Entry m : metadata.entrySet()) {
                    if (AXSchemaType.valueOfNamespace((String)m.getKey()) != null) {
                        group.setMetadataValue(AXSchemaType.valueOfNamespace((String)m.getKey()), (String)m.getValue());
                        continue;
                    }
                    if (EXistSchemaType.valueOfNamespace((String)m.getKey()) == null) continue;
                    group.setMetadataValue(EXistSchemaType.valueOfNamespace((String)m.getKey()), (String)m.getValue());
                }
                return group;
            }
            return null;
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, (Throwable)xre);
        }
        catch (PermissionDeniedException pde) {
            throw new XMLDBException(4, (Throwable)pde);
        }
    }

    @Override
    public void removeAccount(Account u) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(u.getName());
            this.collection.getClient().execute("removeAccount", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void removeGroup(Group role) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(role.getName());
            this.collection.getClient().execute("removeGroup", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setCollection(Collection collection) throws XMLDBException {
        this.collection = (RemoteCollection)collection;
    }

    @Override
    public void setProperty(String property, String value) throws XMLDBException {
    }

    @Override
    public void updateAccount(Account user) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(user.getName());
            params.add(user.getPassword() == null ? "" : user.getPassword());
            params.add(user.getDigestPassword() == null ? "" : user.getDigestPassword());
            String[] gl = user.getGroups();
            params.add(gl);
            params.add(user.isEnabled());
            params.add(user.getUserMask());
            HashMap<String, String> metadata = new HashMap<String, String>();
            for (SchemaType key : user.getMetadataKeys()) {
                metadata.put(key.getNamespace(), user.getMetadataValue(key));
            }
            params.add(metadata);
            this.collection.getClient().execute("updateAccount", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void updateGroup(Group group) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(group.getName());
            String[] managers = new String[group.getManagers().size()];
            for (int i = 0; i < managers.length; ++i) {
                managers[i] = group.getManagers().get(i).getName();
            }
            params.add(managers);
            HashMap<String, String> metadata = new HashMap<String, String>();
            for (SchemaType key : group.getMetadataKeys()) {
                metadata.put(key.getNamespace(), group.getMetadataValue(key));
            }
            params.add(metadata);
            this.collection.getClient().execute("updateGroup", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedException pde) {
            throw new XMLDBException(4, pde.getMessage(), (Throwable)pde);
        }
    }

    @Override
    public String[] getGroupMembers(String groupName) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(groupName);
            Object[] groupMembersResults = (Object[])this.collection.getClient().execute("getGroupMembers", params);
            String[] groupMembers = new String[groupMembersResults.length];
            for (int i = 0; i < groupMembersResults.length; ++i) {
                groupMembers[i] = groupMembersResults[i].toString();
            }
            return groupMembers;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void addAccountToGroup(String accountName, String groupName) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(accountName);
            params.add(groupName);
            this.collection.getClient().execute("addAccountToGroup", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void addGroupManager(String manager, String groupName) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(manager);
            params.add(groupName);
            this.collection.getClient().execute("addGroupManager", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void removeGroupManager(String groupName, String manager) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(groupName);
            params.add(manager);
            this.collection.getClient().execute("removeGroupManager", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void addUserGroup(Account user) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(user.getName());
            String[] gl = user.getGroups();
            params.add(gl);
            this.collection.getClient().execute("updateAccount", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void removeGroupMember(String group, String account) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(group);
            params.add(account);
            this.collection.getClient().execute("removeGroupMember", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String[] getGroups() throws XMLDBException {
        try {
            Object[] v = (Object[])this.collection.getClient().execute("getGroups", Collections.EMPTY_LIST);
            String[] groups = new String[v.length];
            System.arraycopy(v, 0, groups, 0, v.length);
            return groups;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void addUser(User user) throws XMLDBException {
        UserAider account = new UserAider(user.getName());
        this.addAccount(account);
    }

    @Override
    public void updateUser(User user) throws XMLDBException {
        UserAider account = new UserAider(user.getName());
        account.setPassword(user.getPassword());
        this.updateAccount(account);
    }

    @Override
    public User getUser(String name) throws XMLDBException {
        return this.getAccount(name);
    }

    @Override
    public User[] getUsers() throws XMLDBException {
        return null;
    }

    @Override
    public void removeUser(User user) throws XMLDBException {
    }

    @Override
    public void lockResource(Resource res, User u) throws XMLDBException {
        UserAider account = new UserAider(u.getName());
        this.lockResource(res, account);
    }
}

