/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.xmldb.RemoteCollection;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XUpdateQueryService;

public class RemoteXUpdateQueryService
implements XUpdateQueryService {
    private static final Logger LOG = LogManager.getLogger(RemoteXUpdateQueryService.class);
    private RemoteCollection parent;

    public RemoteXUpdateQueryService(RemoteCollection parent) {
        this.parent = parent;
    }

    public String getName() throws XMLDBException {
        return "XUpdateQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public long update(String commands) throws XMLDBException {
        LOG.debug("processing xupdate:\n" + commands);
        ArrayList<Object> params = new ArrayList<Object>();
        byte[] xupdateData = commands.getBytes(StandardCharsets.UTF_8);
        params.add(this.parent.getPath());
        params.add(xupdateData);
        try {
            int mods = (Integer)this.parent.getClient().execute("xupdate", params);
            LOG.debug("processed " + mods + " modifications");
            return mods;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public long updateResource(String id, String commands) throws XMLDBException {
        LOG.debug("processing xupdate:\n" + commands);
        ArrayList<Object> params = new ArrayList<Object>();
        byte[] xupdateData = commands.getBytes(StandardCharsets.UTF_8);
        params.add(this.parent.getPath() + "/" + id);
        params.add(xupdateData);
        try {
            int mods = (Integer)this.parent.getClient().execute("xupdateResource", params);
            LOG.debug("processed " + mods + " modifications");
            return mods;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void setCollection(Collection collection) throws XMLDBException {
        this.parent = (RemoteCollection)collection;
    }

    public String getProperty(String name) throws XMLDBException {
        return null;
    }

    public void setProperty(String name, String value) throws XMLDBException {
    }
}

